/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;

public class IntegratedInitialization
implements ISsfInitialization {
    private final ISsfInitialization initialization;
    private final DoubleSeq delta;

    public IntegratedInitialization(ISsfInitialization initialization, DoubleSeq delta) {
        this.initialization = initialization;
        this.delta = delta;
    }

    private int order() {
        return this.delta.length();
    }

    @Override
    public int getStateDim() {
        return this.initialization.getStateDim() + this.delta.length();
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public int getDiffuseDim() {
        return this.initialization.getDiffuseDim() + this.order();
    }

    @Override
    public void diffuseConstraints(FastMatrix b) {
        int d = this.order();
        b.extract(0, d, 0, d).diagonal().set(1.0);
        this.initialization.diffuseConstraints(b.dropTopLeft(d, d));
    }

    @Override
    public void a0(DataBlock a0) {
        this.initialization.a0(a0.drop(this.order(), 0));
    }

    @Override
    public void Pf0(FastMatrix pf0) {
        int d = this.order();
        this.initialization.Pf0(pf0.dropTopLeft(d, d));
    }

    @Override
    public void Pi0(FastMatrix pi0) {
        int d = this.order();
        pi0.extract(0, d, 0, d).diagonal().set(1.0);
        this.initialization.Pi0(pi0.dropTopLeft(d, d));
    }
}

