/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

public class IntegratedDynamics
implements ISsfDynamics {
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final DoubleSeq delta;

    public IntegratedDynamics(ISsfDynamics dynamics, ISsfLoading loading, DoubleSeq delta) {
        this.dynamics = dynamics;
        this.loading = loading;
        this.delta = delta;
    }

    private int order() {
        return this.delta.length();
    }

    @Override
    public int getInnovationsDim() {
        return this.dynamics.getInnovationsDim();
    }

    @Override
    public void V(int pos, FastMatrix qm) {
        this.dynamics.V(pos, qm.dropTopLeft(this.order(), this.order()));
    }

    @Override
    public void S(int pos, FastMatrix cm) {
        this.dynamics.S(pos, cm.dropTopLeft(this.order(), 0));
    }

    @Override
    public boolean hasInnovations(int pos) {
        return this.dynamics.hasInnovations(pos);
    }

    @Override
    public boolean areInnovationsTimeInvariant() {
        return this.dynamics.areInnovationsTimeInvariant();
    }

    @Override
    public void T(int pos, FastMatrix tr) {
        int d = this.order();
        FastMatrix D = tr.extract(0, d, 0, d);
        D.subDiagonal(-1).set(1.0);
        DataBlock r0 = tr.row(0);
        r0.extract(0, d).setAY(-1.0, this.delta);
        this.loading.Z(pos, r0.drop(d, 0));
        this.dynamics.T(pos, tr.dropTopLeft(d, d));
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int d = this.order();
        DataBlock x0 = x.extract(0, d);
        DataBlock x1 = x.drop(d, 0);
        double z = this.loading.ZX(pos, x1) - this.delta.dot((DoubleSeq)x0);
        x0.fshift(1);
        x0.set(0, z);
        this.dynamics.TX(pos, x1);
    }

    @Override
    public void addSU(int pos, DataBlock x, DataBlock u) {
        int d = this.order();
        DataBlock x1 = x.drop(d, 0);
        this.dynamics.addSU(pos, x1, u);
    }

    @Override
    public void addV(int pos, FastMatrix p) {
        int d = this.order();
        this.dynamics.addV(pos, p.dropTopLeft(d, d));
    }

    @Override
    public void XT(int pos, DataBlock x) {
        int d = this.order();
        DataBlock x0 = x.extract(0, d);
        DataBlock x1 = x.drop(d, 0);
        this.dynamics.XT(pos, x1);
        double w = x0.get(0);
        this.loading.XpZd(pos, x1, w);
        x0.bshiftAndZero();
        x0.addAY(-w, this.delta);
    }

    @Override
    public void XS(int pos, DataBlock x, DataBlock xs) {
        int d = this.order();
        xs.extract(0, d).set(0.0);
        DataBlock x1 = x.drop(d, 0);
        this.dynamics.XS(pos, x1, xs.drop(d, 0));
    }

    @Override
    public boolean isTimeInvariant() {
        return this.dynamics.isTimeInvariant();
    }
}

