/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.DiffuseInitialization;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.ConstantDynamics;
import lombok.Generated;

public final class Coefficients {
    public static StateComponent timeVaryingCoefficients(DoubleSeq vars) {
        int nx = vars.length();
        if (nx == 1) {
            return new StateComponent(new DiffuseInitialization(nx), Dynamics.of(nx, vars.get(0)));
        }
        return new StateComponent(new DiffuseInitialization(nx), Dynamics.of(vars));
    }

    public static StateComponent timeVaryingCoefficient(DoubleSeq std, double scale) {
        return new StateComponent(new DiffuseInitialization(1), Dynamics.of(std, scale));
    }

    public static StateComponent timeVaryingCoefficients(FastMatrix vars) {
        int nx = vars.getColumnsCount();
        return new StateComponent(new DiffuseInitialization(nx), Dynamics.of(vars));
    }

    public static StateComponent fixedCoefficients(int nx) {
        return new StateComponent(new DiffuseInitialization(nx), new ConstantDynamics());
    }

    @Generated
    private Coefficients() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static final class Dynamics {
        static ISsfDynamics of(int n, double var) {
            return new TimeVaryingCDiag(n, var);
        }

        static ISsfDynamics of(DoubleSeq dvar) {
            return new TimeVaryingDiag(dvar);
        }

        static ISsfDynamics of(FastMatrix var) {
            return new TimeVaryingFull(var);
        }

        static ISsfDynamics of(DoubleSeq stde, double scale) {
            return new TimeVaryingInnovations(stde, scale);
        }

        @Generated
        private Dynamics() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static class TimeVaryingCDiag
        implements ISsfDynamics {
            private final int n;
            private final double var;
            private final double std;

            TimeVaryingCDiag(int n, double var) {
                this.n = n;
                this.var = var;
                this.std = Math.sqrt(var);
            }

            @Override
            public boolean isTimeInvariant() {
                return true;
            }

            @Override
            public boolean areInnovationsTimeInvariant() {
                return true;
            }

            @Override
            public int getInnovationsDim() {
                return this.n;
            }

            @Override
            public void V(int pos, FastMatrix qm) {
                qm.diagonal().set(this.var);
            }

            @Override
            public boolean hasInnovations(int pos) {
                return true;
            }

            @Override
            public void S(int pos, FastMatrix sm) {
                sm.diagonal().set(this.std);
            }

            @Override
            public void addSU(int pos, DataBlock x, DataBlock u) {
                int n = x.length();
                for (int i = 0; i < n; ++i) {
                    x.add(i, u.get(i) * this.std);
                }
            }

            @Override
            public void XS(int pos, DataBlock x, DataBlock xs) {
                int n = x.length();
                for (int i = 0; i < n; ++i) {
                    xs.set(i, x.get(i) * this.std);
                }
            }

            @Override
            public void T(int pos, FastMatrix tr) {
                tr.diagonal().set(1.0);
            }

            @Override
            public void TX(int pos, DataBlock x) {
            }

            @Override
            public void XT(int pos, DataBlock x) {
            }

            @Override
            public void TVT(int pos, FastMatrix v) {
            }

            @Override
            public void addV(int pos, FastMatrix p) {
                p.diagonal().add(this.var);
            }
        }

        static class TimeVaryingDiag
        implements ISsfDynamics {
            private final DataBlock var;
            private final DataBlock std;

            TimeVaryingDiag(double[] var) {
                this.var = DataBlock.copyOf(var);
                this.std = DataBlock.copyOf(var);
                this.std.apply(x -> Math.sqrt(x));
            }

            TimeVaryingDiag(DoubleSeq var) {
                this.var = DataBlock.of(var);
                this.std = DataBlock.of(var);
                this.std.apply(x -> Math.sqrt(x));
            }

            @Override
            public boolean isTimeInvariant() {
                return true;
            }

            @Override
            public boolean areInnovationsTimeInvariant() {
                return true;
            }

            @Override
            public int getInnovationsDim() {
                return this.var.length();
            }

            @Override
            public void V(int pos, FastMatrix qm) {
                qm.diagonal().copy(this.var);
            }

            @Override
            public boolean hasInnovations(int pos) {
                return true;
            }

            @Override
            public void S(int pos, FastMatrix sm) {
                sm.diagonal().copy(this.std);
            }

            @Override
            public void addSU(int pos, DataBlock x, DataBlock u) {
                int n = x.length();
                for (int i = 0; i < n; ++i) {
                    x.add(i, u.get(i) * this.std.get(i));
                }
            }

            @Override
            public void XS(int pos, DataBlock x, DataBlock xs) {
                int n = x.length();
                for (int i = 0; i < n; ++i) {
                    xs.set(i, x.get(i) * this.std.get(i));
                }
            }

            @Override
            public void T(int pos, FastMatrix tr) {
                tr.diagonal().set(1.0);
            }

            @Override
            public void TX(int pos, DataBlock x) {
            }

            @Override
            public void XT(int pos, DataBlock x) {
            }

            @Override
            public void TVT(int pos, FastMatrix v) {
            }

            @Override
            public void addV(int pos, FastMatrix p) {
                p.diagonal().add(this.var);
            }
        }

        static class TimeVaryingFull
        implements ISsfDynamics {
            private final FastMatrix var;
            private final FastMatrix s;

            TimeVaryingFull(FastMatrix var) {
                this.var = var;
                this.s = var.deepClone();
                SymmetricMatrix.lcholesky(this.s, 1.0E-9);
            }

            TimeVaryingFull(FastMatrix var, FastMatrix s) {
                this.var = var;
                this.s = s;
            }

            @Override
            public boolean isTimeInvariant() {
                return true;
            }

            @Override
            public boolean areInnovationsTimeInvariant() {
                return true;
            }

            @Override
            public int getInnovationsDim() {
                return this.var.getColumnsCount();
            }

            @Override
            public void V(int pos, FastMatrix qm) {
                qm.copy(this.var);
            }

            @Override
            public boolean hasInnovations(int pos) {
                return true;
            }

            @Override
            public void S(int pos, FastMatrix sm) {
                sm.copy(this.s);
            }

            @Override
            public void addSU(int pos, DataBlock x, DataBlock u) {
                x.addProduct(this.s.rowsIterator(), u);
            }

            @Override
            public void XS(int pos, DataBlock x, DataBlock xs) {
                xs.product(x, this.s.columnsIterator());
            }

            @Override
            public void T(int pos, FastMatrix tr) {
                tr.diagonal().set(1.0);
            }

            @Override
            public void TX(int pos, DataBlock x) {
            }

            @Override
            public void XT(int pos, DataBlock x) {
            }

            @Override
            public void TVT(int pos, FastMatrix v) {
            }

            @Override
            public void addV(int pos, FastMatrix p) {
                p.add(this.var);
            }
        }

        static class TimeVaryingInnovations
        implements ISsfDynamics {
            private final double[] std;
            private final double scale;
            private final double scale2;

            TimeVaryingInnovations(DoubleSeq stde, double scale) {
                this.std = stde.toArray();
                this.scale = scale;
                this.scale2 = scale * scale;
            }

            double stderr(int pos) {
                return pos >= this.std.length ? this.scale : this.scale * this.std[pos];
            }

            double var(int pos) {
                return pos >= this.std.length ? this.scale2 : this.scale2 * this.std[pos] * this.std[pos];
            }

            @Override
            public boolean isTimeInvariant() {
                return false;
            }

            @Override
            public boolean areInnovationsTimeInvariant() {
                return false;
            }

            @Override
            public int getInnovationsDim() {
                return 1;
            }

            @Override
            public void V(int pos, FastMatrix qm) {
                qm.set(0, 0, this.var(pos));
            }

            @Override
            public boolean hasInnovations(int pos) {
                return true;
            }

            @Override
            public void S(int pos, FastMatrix sm) {
                sm.set(0, 0, this.stderr(pos));
            }

            @Override
            public void addSU(int pos, DataBlock x, DataBlock u) {
                x.add(0, this.stderr(pos) * u.get(0));
            }

            @Override
            public void XS(int pos, DataBlock x, DataBlock xs) {
                xs.set(0, x.get(0) * this.stderr(pos));
            }

            @Override
            public void T(int pos, FastMatrix tr) {
                tr.diagonal().set(1.0);
            }

            @Override
            public void TX(int pos, DataBlock x) {
            }

            @Override
            public void XT(int pos, DataBlock x) {
            }

            @Override
            public void TVT(int pos, FastMatrix v) {
            }

            @Override
            public void addV(int pos, FastMatrix p) {
                p.add(this.var(pos));
            }
        }
    }
}

