/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.arima;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.lapack.SYRK;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import lombok.Generated;

public final class SsfArma2 {
    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static StateComponent stateComponent(IArimaModel arima) {
        if (!arima.isStationary()) {
            return null;
        }
        Data data = new Data(arima);
        Initialization initialization = new Initialization(arima, data.dim);
        Dynamics dynamics = new Dynamics(data);
        return new StateComponent(initialization, dynamics);
    }

    public static Ssf ssf(IArimaModel arima) {
        return Ssf.of(SsfArma2.stateComponent(arima), SsfArma2.defaultLoading());
    }

    public static FastMatrix unconditionalCovariance(IArimaModel arma) {
        int p = arma.getArOrder();
        int q = arma.getMaOrder();
        int r = Math.max(p, q + 1);
        FastMatrix V0 = FastMatrix.square(r);
        SsfArma2.unconditionalCovariance(arma, V0);
        return V0;
    }

    private static void unconditionalCovariance(IArimaModel arma, FastMatrix V0) {
        AutoCovarianceFunction acf = arma.getAutoCovarianceFunction();
        double var = arma.getInnovationVariance();
        Polynomial ar = arma.getAr().asPolynomial();
        Polynomial ma = arma.getMa().asPolynomial();
        int dim = V0.getColumnsCount();
        double[] phi = ar.coefficients().toArray();
        double[] theta = ma.coefficients().toArray();
        double[] ac = acf.values(dim);
        DataBlock C0 = V0.column(0);
        C0.set(0, ac[0]);
        double[] lambda = SsfArma2.lambda(phi, theta, var);
        int p = ar.degree();
        int q = ma.degree();
        for (int i = 2; i <= dim; ++i) {
            double c = 0.0;
            for (int j = i; j <= dim; ++j) {
                if (j <= p) {
                    c -= phi[j] * ac[j - i + 1];
                }
                if (j > q + 1) continue;
                c += theta[j - 1] * lambda[j - i];
            }
            C0.set(i - 1, c);
        }
        SsfArma2.recursion(phi, theta, var, V0);
    }

    static double[] lambda(double[] phi, double[] theta, double var) {
        int q = theta.length - 1;
        int p = phi.length - 1;
        double[] l = new double[q + 1];
        l[0] = var;
        for (int k = 1; k <= q; ++k) {
            double lk = theta[k] * var;
            int jmax = Math.min(p, k);
            for (int j = 1; j <= jmax; ++j) {
                lk -= phi[j] * l[k - j];
            }
            l[k] = lk;
        }
        return l;
    }

    static void recursion(double[] phi, double[] theta, double v, FastMatrix V) {
        int n = V.getColumnsCount();
        for (int d = 0; d < n; ++d) {
            int j = 1;
            for (int i = d + 1; i < n; ++i) {
                double vij = V.get(i - 1, j - 1);
                double phii = i < phi.length ? phi[i] : 0.0;
                double phij = j < phi.length ? phi[j] : 0.0;
                double thetai = i <= theta.length ? theta[i - 1] : 0.0;
                double thetaj = j <= theta.length ? theta[j - 1] : 0.0;
                vij += phij * (V.get(i, 0) - phii * V.get(0, 0));
                vij += phii * V.get(j, 0);
                V.set(i, j, vij -= v * thetai * thetaj);
                ++j;
            }
        }
        SymmetricMatrix.fromLower(V);
    }

    @Generated
    private SsfArma2() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        final int dim;
        final double var;
        final double se;
        final double[] phi;
        final double[] theta;

        int q() {
            return this.theta.length - 1;
        }

        int p() {
            return this.phi.length - 1;
        }

        int r() {
            return Math.max(this.theta.length, this.phi.length - 1);
        }

        Data(IArimaModel arima) {
            this.var = arima.getInnovationVariance();
            Polynomial ar = arima.getAr().asPolynomial();
            Polynomial ma = arima.getMa().asPolynomial();
            this.dim = Math.max(ar.degree(), ma.degree() + 1);
            this.phi = ar.coefficients().toArray();
            this.theta = ma.coefficients().toArray();
            this.se = Math.sqrt(this.var);
        }
    }

    static class Initialization
    implements ISsfInitialization {
        final int dim;
        final IArimaModel arma;

        Initialization(IArimaModel arma, int dim) {
            this.arma = arma;
            this.dim = dim;
        }

        @Override
        public int getStateDim() {
            return this.dim;
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix fm) {
        }

        @Override
        public void a0(DataBlock db) {
            db.set(0.0);
        }

        @Override
        public void Pf0(FastMatrix fm) {
            SsfArma2.unconditionalCovariance(this.arma, fm);
        }

        @Override
        public void Pi0(FastMatrix pi0) {
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        final Data data;
        final FastMatrix V;

        Dynamics(Data data) {
            this.data = data;
            int n = data.dim;
            this.V = FastMatrix.square(n);
            int q = data.q();
            FastMatrix Vc = this.V.extract(0, q + 1, 0, q + 1);
            SYRK.laddaXXt(data.var, DataPointer.of(data.theta, 0), Vc);
            SymmetricMatrix.fromLower(Vc);
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int i, FastMatrix vm) {
            vm.copy(this.V);
        }

        @Override
        public void S(int i, FastMatrix sm) {
            double[] s = sm.getStorage();
            for (int j = 0; j < this.data.theta.length; ++j) {
                s[j] = this.data.se * this.data.theta[j];
            }
        }

        @Override
        public boolean hasInnovations(int i) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int i, FastMatrix t) {
            t.subDiagonal(1).set(1.0);
            int p = this.data.p();
            DataBlock t0 = t.column(0);
            for (int j = 1; j <= p; ++j) {
                t0.set(j - 1, -this.data.phi[j]);
            }
        }

        @Override
        public void TX(int i, DataBlock x) {
            int p = this.data.p();
            double x0 = x.get(0);
            x.bshiftAndZero();
            if (p > 0 && x0 != 0.0) {
                DoubleSeqCursor.OnMutable cursor = x.cursor();
                for (int j = 1; j <= p; ++j) {
                    double phi = this.data.phi[j];
                    cursor.applyAndNext(cur -> cur - phi * x0);
                }
            }
        }

        @Override
        public void addSU(int i, DataBlock x, DataBlock u) {
            double a = u.get(0) * this.data.se;
            double[] px = x.getStorage();
            int q = this.data.q();
            int j = 0;
            int k = x.getStartPosition();
            while (j <= q) {
                int n = k;
                px[n] = px[n] + a * this.data.theta[j];
                ++j;
                k += x.getIncrement();
            }
        }

        @Override
        public void addV(int i, FastMatrix fm) {
            fm.add(this.V);
        }

        @Override
        public void XT(int i, DataBlock x) {
            double[] px = x.getStorage();
            double x0 = 0.0;
            int p = this.data.p();
            int j = 1;
            int k = x.getStartPosition();
            while (j <= p) {
                x0 -= px[k] * this.data.phi[j];
                ++j;
                k += x.getIncrement();
            }
            x.fshift(1);
            x.set(0, x0);
        }

        @Override
        public void XS(int i, DataBlock x, DataBlock sx) {
            double a = 0.0;
            double[] px = x.getStorage();
            int q = this.data.q();
            int j = 0;
            int k = x.getStartPosition();
            while (j <= q) {
                a += px[k] * this.data.theta[j];
                ++j;
                k += x.getIncrement();
            }
            sx.set(0, a);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }
}

