/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.arima;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.arima.AR1;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class Arima_1_1_0 {
    public static StateComponent of(double rho) {
        AR1.Data data = new AR1.Data(rho, 1.0, false);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static StateComponent of(double rho, double var, boolean zeroinit) {
        AR1.Data data = new AR1.Data(rho, var, zeroinit);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.sum();
    }

    @Generated
    private Arima_1_1_0() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        private final AR1.Data data;

        Initialization(AR1.Data data) {
            this.data = data;
        }

        @Override
        public int getStateDim() {
            return 2;
        }

        @Override
        public boolean isDiffuse() {
            return !this.data.zeroinit;
        }

        @Override
        public int getDiffuseDim() {
            return this.data.zeroinit ? 0 : 1;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            if (!this.data.zeroinit) {
                b.set(0, 0, 1.0);
            }
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            if (this.data.zeroinit) {
                pf0.set(1, 1, this.data.var);
            } else {
                pf0.set(1, 1, this.data.var / (1.0 - this.data.rho * this.data.rho));
            }
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            if (!this.data.zeroinit) {
                pi0.set(0, 0, 1.0);
            }
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final AR1.Data data;

        Dynamics(AR1.Data data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(1, 1, this.data.var);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            sm.set(1, 0, this.data.std());
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(1, this.data.std() * u.get(0));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, this.data.std() * x.get(1));
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, 1.0);
            tr.set(0, 1, 1.0);
            tr.set(1, 1, this.data.rho);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.set(0, x.sum());
            x.mul(1, this.data.rho);
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            double v00 = vm.get(0, 0);
            double v01 = vm.get(0, 1);
            double v10 = vm.get(1, 0);
            double v11 = vm.get(1, 1);
            vm.set(0, 0, v00 + v01 + v10 + v11);
            vm.set(0, 1, this.data.rho * (v01 + v11));
            vm.set(1, 0, this.data.rho * (v10 + v11));
            vm.set(1, 1, this.data.rho * this.data.rho * v11);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.set(1, x.get(0) + this.data.rho * x.get(1));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(1, 1, this.data.var);
        }
    }
}

