/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.Householder2;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.ProfileLikelihood;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.FastFilter;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;

public class QRFilter {
    private ISsfData o;
    private FastMatrix X;
    private FastMatrix Xl;
    private DataBlock yl;
    private double ldet;
    private static final double EPS = 1.0E-12;

    public boolean process(ISsf ssf, ISsfData data) {
        this.clear();
        this.o = data;
        OrdinaryFilter filter = new OrdinaryFilter();
        DefaultFilteringResults fr2 = DefaultFilteringResults.light();
        fr2.prepare(ssf, 0, data.length());
        if (!filter.process(ssf, data, fr2)) {
            return false;
        }
        DeterminantalTerm det = new DeterminantalTerm();
        DoubleSeq vars = fr2.errorVariances();
        for (int i = 0; i < vars.length(); ++i) {
            double v = vars.get(i);
            if (data.isMissing(i) || v == 0.0) continue;
            det.add(v);
        }
        this.ldet = det.getLogDeterminant();
        this.X = FastMatrix.make(data.length(), ssf.getDiffuseDim());
        ssf.diffuseEffects(this.X);
        this.yl = DataBlock.of(fr2.errors(true, true));
        FastFilter ffilter = new FastFilter(ssf, fr2);
        int n = ffilter.getOutputLength(this.X.getRowsCount());
        this.Xl = FastMatrix.make(n, this.X.getColumnsCount());
        for (int i = 0; i < this.X.getColumnsCount(); ++i) {
            ffilter.apply((DoubleSeq)this.X.column(i), this.Xl.column(i));
        }
        return true;
    }

    public MarginalLikelihood marginalLikelihood(boolean scalingFactor, boolean res) {
        DiffuseLikelihood dll = this.diffuseLikelihood(false, res);
        FastMatrix Q = this.X;
        if (this.X.getRowsCount() != this.Xl.getRowsCount()) {
            Q = FastMatrix.make(this.Xl.getRowsCount(), this.X.getColumnsCount());
            int j = 0;
            for (int i = 0; i < this.o.length(); ++i) {
                if (this.o.isMissing(i)) continue;
                Q.row(j++).copy(this.X.row(i));
            }
        }
        QRDecomposition qrx = new Householder2().decompose(Q);
        double mcorr = 2.0 * LogSign.of(qrx.rawRdiagonal()).getValue();
        int nd = UpperTriangularMatrix.rank(qrx.rawR(), 1.0E-12);
        int n = this.Xl.getRowsCount();
        return MarginalLikelihood.builder(n, nd).ssqErr(dll.ssq()).logDeterminant(this.ldet).diffuseCorrection(dll.getDiffuseCorrection()).marginalCorrection(mcorr).residuals(dll.e()).concentratedScalingFactor(scalingFactor).build();
    }

    public DiffuseLikelihood diffuseLikelihood(boolean scalingFactor, boolean res) {
        Householder2 hous = new Householder2();
        QRDecomposition qr = hous.decompose(this.Xl.deepClone());
        QRLeastSquaresSolution ls = QRLeastSquaresSolver.leastSquares(qr, (DoubleSeq)this.yl, 1.0E-12);
        DataBlock b = DataBlock.of(ls.getB());
        DataBlock e = DataBlock.of(ls.getE());
        int nd = b.length();
        int n = this.Xl.getRowsCount();
        double ssq = ls.getSsqErr();
        double dcorr = 2.0 * LogSign.of(ls.rawRDiagonal()).getValue();
        return DiffuseLikelihood.builder(n, nd).ssqErr(ssq).logDeterminant(this.ldet).diffuseCorrection(dcorr).concentratedScalingFactor(scalingFactor).residuals((DoubleSeq)(res ? e : null)).build();
    }

    public ProfileLikelihood profileLikelihood() {
        Householder2 hous = new Householder2();
        QRDecomposition qr = hous.decompose(this.Xl.deepClone());
        QRLeastSquaresSolution ls = QRLeastSquaresSolver.leastSquares(qr, (DoubleSeq)this.yl, 1.0E-12);
        DataBlock b = DataBlock.of(ls.getB());
        int n = this.Xl.getRowsCount();
        double ssq = ls.getSsqErr();
        FastMatrix R = ls.rawR();
        FastMatrix bvar = SymmetricMatrix.UUt(UpperTriangularMatrix.inverse(R));
        bvar.mul(ssq / (double)n);
        ProfileLikelihood pll = new ProfileLikelihood();
        pll.set(ssq, this.ldet, b, bvar, n);
        pll.set(ls.getE());
        return pll;
    }

    private void clear() {
        this.o = null;
        this.ldet = 0.0;
        this.X = null;
        this.Xl = null;
        this.yl = null;
    }
}

