/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfState;
import jdplus.toolkit.base.core.ssf.State;

public class AugmentedState
extends State {
    private final FastMatrix B;
    private int ndropped = 0;

    public static AugmentedState of(ISsfState ssf) {
        ISsfInitialization initialization = ssf.initialization();
        AugmentedState state = new AugmentedState(initialization.getStateDim(), initialization.getDiffuseDim());
        initialization.a0(state.a());
        initialization.Pf0(state.P());
        if (initialization.isDiffuse()) {
            initialization.diffuseConstraints(state.B);
        }
        return state;
    }

    public AugmentedState(int dim, int ndiffuse) {
        super(dim);
        this.B = FastMatrix.make(dim, ndiffuse);
    }

    public final FastMatrix B() {
        return this.B.extract(0, this.B.getRowsCount(), this.ndropped, this.B.getColumnsCount() - this.ndropped);
    }

    public void restoreB(FastMatrix b) {
        int n = b.getColumnsCount();
        int m = this.B.getColumnsCount();
        this.ndropped = m - n;
        this.B().copy(b);
    }

    public final void dropDiffuseConstraint() {
        ++this.ndropped;
    }

    public final void dropAllConstraints() {
        this.ndropped = this.B.getColumnsCount();
    }

    public final boolean isDiffuse() {
        return this.ndropped < this.B.getColumnsCount();
    }

    public int getDiffuseDim() {
        return this.B.getColumnsCount() - this.ndropped;
    }

    @Override
    public void next(int pos, ISsfDynamics dynamics) {
        super.next(pos, dynamics);
        if (this.isDiffuse()) {
            dynamics.TM(pos, this.B);
        }
    }
}

