/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.akf.AugmentedUpdateInformation;
import jdplus.toolkit.base.core.ssf.akf.IAugmentedFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.IQFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class AugmentedFilter {
    private AugmentedState state;
    private AugmentedUpdateInformation pe;
    private ISsf ssf;
    private ISsfLoading loading;
    private ISsfError error;
    private ISsfDynamics dynamics;
    private ISsfData data;
    private boolean missing;
    private final boolean collapsing;
    private int collapsingPos = -1;

    public AugmentedFilter() {
        this.collapsing = false;
    }

    public AugmentedFilter(boolean collapsing) {
        this.collapsing = collapsing;
    }

    protected boolean error(int t) {
        this.missing = this.data.isMissing(t);
        if (this.missing) {
            this.pe.E().set(0.0);
            this.pe.M().set(0.0);
            return false;
        }
        DataBlock C = this.pe.M();
        this.loading.ZM(t, this.state.P(), C);
        double v = this.loading.ZX(t, C);
        if (this.error != null) {
            v += this.error.at(t);
        }
        if (v < 1.0E-9) {
            v = 0.0;
        }
        this.pe.setVariance(v);
        double y = this.data.get(t);
        this.pe.set(y - this.loading.ZX(t, this.state.a()), this.data.isConstraint(t));
        this.loading.ZM(t, this.state.B(), this.pe.E());
        this.pe.E().apply(x -> -x);
        return true;
    }

    protected void update() {
        double v = this.pe.getVariance();
        double e = this.pe.get();
        if (v == 0.0) {
            if (Math.abs(e) < 1.0E-9) {
                return;
            }
            throw new SsfException("Inconsistent constraints in the model");
        }
        this.state.a().addAY(e / v, this.pe.M());
        DataBlockIterator acols = this.state.B().columnsIterator();
        DoubleSeqCursor.OnMutable cell = this.pe.E().cursor();
        while (acols.hasNext()) {
            acols.next().addAY(cell.getAndNext() / v, this.pe.M());
        }
        this.update(this.state.P(), v, this.pe.M());
    }

    public AugmentedState getState() {
        return this.state;
    }

    public int getCollapsingPosition() {
        return this.collapsingPos;
    }

    private boolean initState() {
        this.state = AugmentedState.of(this.ssf);
        if (this.state == null) {
            return false;
        }
        ISsfInitialization initialization = this.ssf.initialization();
        this.pe = new AugmentedUpdateInformation(initialization.getStateDim(), initialization.getDiffuseDim());
        return true;
    }

    public boolean process(ISsf ssf, ISsfData data, IQFilteringResults rslts) {
        this.ssf = ssf;
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.data = data;
        if (!this.initState()) {
            return false;
        }
        int t = 0;
        int end = data.length();
        while (t < end) {
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Forecast);
            }
            if (this.collapse(t, rslts)) break;
            if (this.error(t)) {
                if (rslts != null) {
                    rslts.save(t, this.pe);
                }
                this.update();
            }
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Concurrent);
            }
            this.state.next(t++, this.dynamics);
        }
        return true;
    }

    public boolean process(ISsf ssf, ISsfData data, IAugmentedFilteringResults rslts) {
        this.ssf = ssf;
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.data = data;
        if (!this.initState()) {
            return false;
        }
        int t = 0;
        int end = data.length();
        while (t < end) {
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Forecast);
            }
            if (this.error(t)) {
                if (rslts != null) {
                    rslts.save(t, this.pe);
                }
                this.update();
            }
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Concurrent);
            }
            this.state.next(t++, this.dynamics);
        }
        return true;
    }

    private void update(FastMatrix P, double v, DataBlock C) {
        P.addXaXt(-1.0 / v, C);
    }

    protected boolean collapse(int t, IQFilteringResults decomp) {
        if (!this.collapsing) {
            return false;
        }
        if (!decomp.collapse(t, this.state)) {
            return false;
        }
        this.collapsingPos = t;
        return true;
    }
}

