/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.sarima.estimation;

import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.core.ar.AutoRegressiveEstimation;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.normalizer.AbsMeanNormalizer;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.sarima.SarimaModel;

public class HannanRissanen {
    private SarimaModel m_model;
    private SarmaOrders m_spec;
    private final boolean biascorrection;
    private final boolean finalcorrection;
    private final Initialization initialization;
    private double[] m_data;
    private double[] m_a;
    private double[] m_pi;
    private DoubleSeq m_odata;
    private double bic;
    private static final int MAXNPI = 50;
    private static final double OVERFLOW = 1.0E16;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isBiasCorrection() {
        return this.biascorrection;
    }

    public boolean isFinalCorrection() {
        return this.finalcorrection;
    }

    public Initialization getInitialization() {
        return this.initialization;
    }

    public double getBic() {
        return this.bic;
    }

    private HannanRissanen(Builder builder) {
        this.initialization = builder.initialization;
        this.finalcorrection = builder.finalcorrection;
        this.biascorrection = builder.biascorrection;
    }

    private double[] ls(FastMatrix mat, double[] y, boolean bbic) {
        QRLeastSquaresSolution rslt = QRLeastSquaresSolver.fastLeastSquares((DoubleSeq)DataBlock.of(y), mat);
        DoubleSeq pi = rslt.getB();
        int n = y.length;
        int m = pi.count(x -> x != 0.0);
        if (bbic) {
            this.bic = Math.log(rslt.getSsqErr() / (double)n) + Math.log(n) * (double)m / (double)n;
        }
        return pi.toArray();
    }

    private void biascorrection() {
        int n = this.m_data.length;
        int np = this.m_spec.getP() + this.m_spec.getBp() * (1 + this.m_spec.getP());
        int nq = this.m_spec.getQ() + this.m_spec.getBq() * (1 + this.m_spec.getQ());
        double[] a1 = new double[n];
        double[] a2 = new double[n];
        double[] res = new double[n];
        FastMatrix mat = FastMatrix.make(n, np + nq);
        double[] mdata = mat.getStorage();
        for (int i = 0; i < n; ++i) {
            int k;
            int l;
            int picur = 0;
            double sum = this.m_data[i];
            double sum1 = 0.0;
            double sum2 = 0.0;
            int j = 1;
            while (j <= this.m_spec.getP()) {
                if (i - j >= 0) {
                    sum += this.m_pi[picur] * this.m_data[i - j];
                    sum1 -= this.m_pi[picur] * a1[i - j];
                    mdata[i + n * picur] = -a1[i - j];
                }
                ++j;
                ++picur;
            }
            for (j = 1; j <= this.m_spec.getBp(); ++j) {
                l = j * this.m_spec.getPeriod();
                if (i - l >= 0) {
                    sum += this.m_pi[picur] * this.m_data[i - l];
                    sum1 -= this.m_pi[picur] * a1[i - l];
                    mdata[i + n * picur] = -a1[i - l];
                }
                ++picur;
                ++l;
                k = 0;
                while (k < this.m_spec.getP()) {
                    if (i - l >= 0) {
                        sum += this.m_pi[picur] * this.m_data[i - l];
                        sum1 -= this.m_pi[picur] * a1[i - l];
                        mdata[i + n * picur] = -a1[i - l];
                    }
                    ++k;
                    ++picur;
                    ++l;
                }
            }
            j = 1;
            while (j <= this.m_spec.getQ()) {
                if (i - j >= 0) {
                    sum -= this.m_pi[picur] * res[i - j];
                    sum2 -= this.m_pi[picur] * a2[i - j];
                    mdata[i + n * picur] = a2[i - j];
                }
                ++j;
                ++picur;
            }
            for (j = 1; j <= this.m_spec.getBq(); ++j) {
                l = j * this.m_spec.getPeriod();
                if (i - l >= 0) {
                    sum -= this.m_pi[picur] * res[i - l];
                    sum2 -= this.m_pi[picur] * a2[i - l];
                    mdata[i + n * picur] = a2[i - l];
                }
                ++picur;
                ++l;
                k = 0;
                while (k < this.m_spec.getQ()) {
                    if (i - l >= 0) {
                        sum -= this.m_pi[picur] * res[i - l];
                        sum2 -= this.m_pi[picur] * a2[i - l];
                        mdata[i + n * picur] = a2[i - l];
                    }
                    ++k;
                    ++picur;
                    ++l;
                }
            }
            if (Math.abs(sum) > 1.0E16) {
                return;
            }
            res[i] = sum;
            a1[i] = sum1 + sum;
            a2[i] = sum2 + sum;
        }
        double[] dpi = this.ls(mat, res, false);
        for (int i = 0; i < dpi.length; ++i) {
            int n2 = i;
            this.m_pi[n2] = this.m_pi[n2] + dpi[i];
        }
    }

    private boolean calc() {
        this.m_model = SarimaModel.builder(this.m_spec).build();
        int p = this.m_spec.getP() + this.m_spec.getPeriod() * this.m_spec.getBp();
        int q = this.m_spec.getQ() + this.m_spec.getPeriod() * this.m_spec.getBq();
        if (p == 0 && q == 0) {
            this.bic = Math.log(DataBlock.of(this.m_data).ssq() / (double)this.m_data.length);
            return true;
        }
        if (q > 0) {
            this.initialize();
        }
        this.minspq();
        if (q > 0 && this.biascorrection) {
            this.biascorrection();
        }
        this.updatemodel();
        if (q > 0 && p > 0 && this.finalcorrection) {
            this.finalcorrection();
        }
        return true;
    }

    private void finalcorrection() {
        BackFilter ar = this.m_model.getAr();
        DataBlock ndata = DataBlock.make(this.m_data.length - ar.getDegree());
        ar.apply(DataBlock.of(this.m_data), ndata);
        HannanRissanen hr = HannanRissanen.builder().biasCorrection(this.biascorrection).finalCorrection(false).build();
        SarmaOrders nspec = this.m_spec.clone();
        nspec.setP(0);
        nspec.setBp(0);
        if (!hr.process((DoubleSeq)ndata, nspec)) {
            return;
        }
        int i = hr.m_pi.length - 1;
        int j = this.m_pi.length - 1;
        while (i >= 0) {
            this.m_pi[j] = hr.m_pi[i];
            --i;
            --j;
        }
        this.updatemodel();
    }

    private void clear() {
        this.m_model = null;
        this.m_a = null;
    }

    public DoubleSeq getData() {
        return this.m_odata;
    }

    public SarimaModel getModel() {
        return this.m_model;
    }

    public SarmaOrders getSpec() {
        return this.m_spec;
    }

    private int npi() {
        int q = this.m_spec.getQ() + this.m_spec.getPeriod() * this.m_spec.getBq();
        int p = this.m_spec.getP() + this.m_spec.getPeriod() * this.m_spec.getBp();
        int n = this.m_data.length;
        double ln = Math.log(n);
        int npi = Math.max((int)(ln * ln), Math.max(p, 2 * q));
        if (npi >= n) {
            npi = n - n / 4;
        }
        if (npi > 50) {
            npi = 50;
        }
        return npi;
    }

    private void initialize() {
        AutoRegressiveEstimation ar = switch (this.initialization.ordinal()) {
            case 0 -> AutoRegressiveEstimation.ols();
            case 2 -> AutoRegressiveEstimation.burg();
            default -> AutoRegressiveEstimation.levinson();
        };
        ar.estimate((DoubleSeq)Doubles.of((double[])this.m_data), this.npi());
        this.m_a = ar.residuals().toArray();
    }

    private void minspq() {
        int k;
        int p = this.m_spec.getP() + this.m_spec.getPeriod() * this.m_spec.getBp();
        int q = this.m_spec.getQ() + this.m_spec.getPeriod() * this.m_spec.getBq();
        int n = this.m_data.length;
        int m = p > q ? p : q;
        int nc = n - m;
        int ccur = 0;
        int np = this.m_spec.getP() + this.m_spec.getBp() * (1 + this.m_spec.getP());
        int nq = this.m_spec.getQ() + this.m_spec.getBq() * (1 + this.m_spec.getQ());
        FastMatrix mat = FastMatrix.make(nc, np + nq);
        double[] dmat = mat.getStorage();
        double[] data = new double[nc];
        System.arraycopy(this.m_data, m, data, 0, nc);
        int i = 1;
        while (i <= this.m_spec.getP()) {
            System.arraycopy(this.m_data, m - i, dmat, ccur, nc);
            ++i;
            ccur += nc;
        }
        for (i = this.m_spec.getPeriod(); i <= this.m_spec.getPeriod() * this.m_spec.getBp(); i += this.m_spec.getPeriod()) {
            k = 0;
            while (k <= this.m_spec.getP()) {
                System.arraycopy(this.m_data, m - i - k, dmat, ccur, nc);
                ++k;
                ccur += nc;
            }
        }
        i = 1;
        while (i <= this.m_spec.getQ()) {
            System.arraycopy(this.m_a, m - i, dmat, ccur, nc);
            ++i;
            ccur += nc;
        }
        for (i = this.m_spec.getPeriod(); i <= this.m_spec.getPeriod() * this.m_spec.getBq(); i += this.m_spec.getPeriod()) {
            k = 0;
            while (k <= this.m_spec.getQ()) {
                System.arraycopy(this.m_a, m - i - k, dmat, ccur, nc);
                ++k;
                ccur += nc;
            }
        }
        this.m_pi = this.ls(mat, data, true);
        for (i = 0; i < np; ++i) {
            this.m_pi[i] = -this.m_pi[i];
        }
    }

    public boolean process(DoubleSeq value, SarmaOrders spec) {
        this.clear();
        this.m_spec = spec.clone();
        this.m_odata = value;
        this.m_data = value.toArray();
        AbsMeanNormalizer normalizer = new AbsMeanNormalizer();
        normalizer.normalize(DataBlock.of(this.m_data));
        return this.calc();
    }

    private void updatemodel() {
        int i;
        if (this.m_pi == null) {
            return;
        }
        int ccur = 0;
        SarimaModel.Builder builder = SarimaModel.builder(this.m_spec);
        if (this.m_spec.getP() != 0) {
            for (i = 1; i <= this.m_spec.getP(); ++i) {
                builder.phi(i, this.m_pi[ccur++]);
            }
        }
        if (this.m_spec.getBp() != 0) {
            for (i = 1; i <= this.m_spec.getBp(); ++i) {
                builder.bphi(i, this.m_pi[ccur]);
                ccur += 1 + this.m_spec.getP();
            }
        }
        if (this.m_spec.getQ() != 0) {
            for (i = 1; i <= this.m_spec.getQ(); ++i) {
                builder.theta(i, this.m_pi[ccur++]);
            }
        }
        if (this.m_spec.getBq() != 0) {
            for (i = 1; i <= this.m_spec.getBq(); ++i) {
                builder.btheta(i, this.m_pi[ccur]);
                ccur += 1 + this.m_spec.getQ();
            }
        }
        this.m_model = builder.build();
    }

    public static class Builder {
        private boolean finalcorrection = true;
        private boolean biascorrection = true;
        private Initialization initialization = Initialization.Levinson;

        public Builder finalCorrection(boolean correction) {
            this.finalcorrection = correction;
            return this;
        }

        public Builder biasCorrection(boolean correction) {
            this.biascorrection = correction;
            return this;
        }

        public Builder initialization(Initialization initialization) {
            this.initialization = initialization;
            return this;
        }

        public HannanRissanen build() {
            return new HannanRissanen(this);
        }
    }

    public static enum Initialization {
        Ols,
        Levinson,
        Burg;

    }
}

