/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.sarima;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import lombok.Generated;

public final class SarimaUtility {
    private static final BackFilter m10 = SarimaUtility.differencingFilter(12, 1, 0);
    private static final BackFilter m20 = SarimaUtility.differencingFilter(12, 2, 0);
    private static final BackFilter m01 = SarimaUtility.differencingFilter(12, 0, 1);
    private static final BackFilter m11 = SarimaUtility.differencingFilter(12, 1, 1);
    private static final BackFilter q10 = SarimaUtility.differencingFilter(4, 1, 0);
    private static final BackFilter q20 = SarimaUtility.differencingFilter(4, 2, 0);
    private static final BackFilter q01 = SarimaUtility.differencingFilter(4, 0, 1);
    private static final BackFilter q11 = SarimaUtility.differencingFilter(4, 1, 1);

    public static BackFilter differencingFilter(int freq, int d, int bd) {
        Polynomial X = null;
        if (d > 0) {
            X = UnitRoots.D(1, d);
        }
        if (bd > 0) {
            Polynomial XD = UnitRoots.D(freq, bd);
            X = X == null ? XD : X.times(XD);
        }
        if (X == null) {
            X = Polynomial.ONE;
        }
        return new BackFilter(X);
    }

    public static BackFilter getDifferencingFilter(SarimaOrders spec) {
        if (spec.getD() == 0 && spec.getBd() == 0) {
            return BackFilter.ONE;
        }
        if (spec.getPeriod() == 12) {
            if (spec.getBd() == 0) {
                if (spec.getD() == 1) {
                    return m10;
                }
                if (spec.getD() == 2) {
                    return m20;
                }
            } else if (spec.getBd() == 1) {
                if (spec.getD() == 0) {
                    return m01;
                }
                if (spec.getD() == 1) {
                    return m11;
                }
            } else if (spec.getPeriod() == 4) {
                if (spec.getBd() == 0) {
                    if (spec.getD() == 1) {
                        return q10;
                    }
                    if (spec.getD() == 2) {
                        return q20;
                    }
                } else if (spec.getBd() == 1) {
                    if (spec.getD() == 0) {
                        return q01;
                    }
                    if (spec.getD() == 1) {
                        return q11;
                    }
                }
            }
        }
        return SarimaUtility.differencingFilter(spec.getPeriod(), spec.getD(), spec.getBd());
    }

    public static UnitRoots getUnitRoots(SarimaOrders spec) {
        int i;
        UnitRoots ur = new UnitRoots();
        if (spec.getPeriod() > 1) {
            for (i = 0; i < spec.getBd(); ++i) {
                ur.add(spec.getPeriod());
            }
        }
        for (i = 0; i < spec.getD(); ++i) {
            ur.add(1);
        }
        return ur;
    }

    @Generated
    private SarimaUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

