/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;
import jdplus.toolkit.base.core.stats.tests.NiidTests;
import jdplus.toolkit.base.core.timeseries.simplets.Transformations;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ModelEstimation {
    private static final boolean[] EB = new boolean[0];
    private final TsData originalSeries;
    private final TsData interpolated;
    private final TsData transformedSeries;
    private final TsDomain estimationDomain;
    private final boolean logTransformation;
    private final LengthOfPeriodType lpTransformation;
    private final int[] missing;
    @NonNull
    private final Variable[] variables;
    private final RegArimaModel<SarimaModel> model;
    private final ConcentratedLikelihoodWithMissing concentratedLikelihood;
    private final int freeArimaParametersCount;
    private final boolean[] fixedArimaParameters;
    private final double[] arimaParameters;
    private final double[] arimaScore;
    private final FastMatrix arimaCovariance;
    private final LikelihoodStatistics statistics;

    public static ModelEstimation of(ModelDescription builder, IRegArimaComputer<SarimaModel> processor) {
        return new ModelEstimation(builder, builder.estimate(processor));
    }

    public static ModelEstimation of(RegSarimaModelling regarima) {
        return new ModelEstimation(regarima.getDescription(), regarima.getEstimation());
    }

    private ModelEstimation(ModelDescription description, RegArimaEstimation<SarimaModel> estimation) {
        this.originalSeries = description.getSeries();
        this.transformedSeries = description.getTransformedSeries();
        this.interpolated = description.getInterpolatedSeries();
        this.logTransformation = description.isLogTransformation();
        this.lpTransformation = description.getPreadjustment();
        this.missing = description.getMissing();
        this.estimationDomain = description.getEstimationDomain();
        SarimaSpec arima = description.getArimaSpec();
        int free = arima.freeParametersCount();
        int all = arima.parametersCount();
        List vars = ((Stream)description.variables().sequential()).collect(Collectors.toList());
        int nvars = vars.size();
        if (description.isMean()) {
            ++nvars;
        }
        this.variables = new Variable[nvars];
        DoubleSeqCursor cursor = estimation.getConcentratedLikelihood().coefficients().cursor();
        int k = 0;
        if (description.isMean()) {
            this.variables[k++] = Variable.variable((String)"const", (ITsVariable)new TrendConstant(arima.getD(), arima.getBd(), description.getEstimationDomain().start()));
        }
        for (Variable var : vars) {
            int j;
            Parameter[] p;
            int nfree = var.freeCoefficientsCount();
            if (nfree == var.dim()) {
                p = new Parameter[nfree];
                for (j = 0; j < nfree; ++j) {
                    p[j] = Parameter.estimated((double)cursor.getAndNext());
                }
                this.variables[k++] = var.withCoefficients(p);
                continue;
            }
            if (nfree > 0) {
                p = var.getCoefficients();
                for (j = 0; j < p.length; ++j) {
                    if (!p[j].isFree()) continue;
                    p[j] = Parameter.estimated((double)cursor.getAndNext());
                }
                this.variables[k++] = var.withCoefficients(p);
                continue;
            }
            this.variables[k++] = var;
        }
        this.model = estimation.getModel();
        this.concentratedLikelihood = estimation.getConcentratedLikelihood();
        this.statistics = estimation.statistics();
        LogLikelihoodFunction.Point<RegArimaModel<SarimaModel>, ConcentratedLikelihoodWithMissing> max = estimation.getMax();
        this.freeArimaParametersCount = arima.freeParametersCount();
        if (max == null) {
            this.arimaParameters = Doubles.EMPTYARRAY;
            this.arimaScore = Doubles.EMPTYARRAY;
            this.arimaCovariance = FastMatrix.EMPTY;
            this.fixedArimaParameters = EB;
        } else {
            this.fixedArimaParameters = null;
            this.arimaParameters = max.getParameters().toArray();
            this.arimaScore = max.getScore().toArray();
            this.arimaCovariance = max.asymptoticCovariance();
        }
    }

    private static double[] expand(double[] params, boolean[] fixedItems, double value) {
        double[] p = new double[fixedItems.length];
        int j = 0;
        for (int i = 0; i < p.length; ++i) {
            p[i] = fixedItems[i] ? value : params[j++];
        }
        return p;
    }

    private static void expand(double[] params, boolean[] fixedItems, double[] values) {
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (fixedItems[i]) continue;
            values[i] = params[j++];
        }
    }

    public static FastMatrix expand(FastMatrix cov, boolean[] fixedItems) {
        int dim = fixedItems.length;
        int[] idx = new int[dim];
        int j = 0;
        for (int i = 0; i < fixedItems.length; ++i) {
            if (fixedItems[i]) continue;
            idx[j++] = i;
        }
        FastMatrix m = FastMatrix.make(fixedItems.length, fixedItems.length);
        for (int i = 0; i < dim; ++i) {
            for (int j2 = 0; j2 <= i; ++j2) {
                double s = cov.get(i, j2);
                m.set(idx[i], idx[j2], s);
                if (i == j2) continue;
                m.set(idx[j2], idx[i], s);
            }
        }
        return m;
    }

    public int getAnnualFrequency() {
        return this.originalSeries.getAnnualFrequency();
    }

    public SarimaOrders specification() {
        return this.model.arima().orders();
    }

    public TsData interpolatedSeries(boolean bTransformed) {
        TsData data = bTransformed ? this.transformedSeries : this.interpolated;
        int nmissing = this.concentratedLikelihood.nmissing();
        if (nmissing > 0) {
            double[] datac = data.getValues().toArray();
            if (bTransformed) {
                DoubleSeqCursor cur = this.concentratedLikelihood.missingCorrections().cursor();
                for (int i = 0; i < nmissing; ++i) {
                    int n = this.missing[i];
                    datac[n] = datac[n] - cur.getAndNext();
                }
            } else {
                DoubleSeqCursor cur = this.concentratedLikelihood.missingCorrections().cursor();
                for (int i = 0; i < nmissing; ++i) {
                    double m = cur.getAndNext();
                    if (this.logTransformation) {
                        int n = this.missing[i];
                        datac[n] = datac[n] / Math.exp(m);
                        continue;
                    }
                    int n = this.missing[i];
                    datac[n] = datac[n] - m;
                }
            }
            data = TsData.ofInternal((TsPeriod)this.originalSeries.getStart(), (double[])datac);
        }
        return data;
    }

    public TsData regressionEffect(TsDomain domain, Predicate<Variable> test) {
        DataBlock all = DataBlock.make(domain.getLength());
        if (this.variables.length > 0) {
            DoubleSeqCursor cursor = this.concentratedLikelihood.coefficients().cursor();
            if (this.model.isMean()) {
                cursor.skip(1);
            }
            for (int i = 0; i < this.variables.length; ++i) {
                Variable cur = this.variables[i];
                int nfree = cur.freeCoefficientsCount();
                if (nfree <= 0) continue;
                if (test.test(cur)) {
                    FastMatrix m = Regression.matrix(domain, cur.getCore());
                    int ic = 0;
                    DataBlockIterator cols = m.columnsIterator();
                    while (cols.hasNext()) {
                        Parameter c;
                        DataBlock col = cols.next();
                        if (!(c = cur.getCoefficient(ic++)).isFree()) continue;
                        all.addAY(cursor.getAndNext(), col);
                    }
                    continue;
                }
                cursor.skip(nfree);
            }
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])all.getStorage());
    }

    public TsData preadjustmentEffect(TsDomain domain, Predicate<Variable> test) {
        DataBlock all = DataBlock.make(domain.getLength());
        if (this.variables.length > 0) {
            for (int i = 0; i < this.variables.length; ++i) {
                Variable cur = this.variables[i];
                int nfree = cur.freeCoefficientsCount();
                if (cur.dim() <= nfree || !test.test(cur)) continue;
                FastMatrix m = Regression.matrix(domain, cur.getCore());
                int ic = 0;
                DataBlockIterator cols = m.columnsIterator();
                while (cols.hasNext()) {
                    Parameter c;
                    DataBlock col = cols.next();
                    if ((c = cur.getCoefficient(ic++)).isFree()) continue;
                    all.addAY(c.getValue(), col);
                }
            }
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])all.getStorage());
    }

    public TsData deterministicEffect(TsDomain domain, Predicate<Variable> test) {
        DataBlock all = DataBlock.make(domain.getLength());
        if (this.variables.length > 0) {
            DoubleSeqCursor cursor = this.concentratedLikelihood.coefficients().cursor();
            for (int i = 0; i < this.variables.length; ++i) {
                Variable cur = this.variables[i];
                if (test.test(cur)) {
                    FastMatrix m = Regression.matrix(domain, cur.getCore());
                    int ic = 0;
                    DataBlockIterator cols = m.columnsIterator();
                    while (cols.hasNext()) {
                        Parameter c;
                        DataBlock col = cols.next();
                        if ((c = cur.getCoefficient(ic++)).isFree()) {
                            all.addAY(cursor.getAndNext(), col);
                            continue;
                        }
                        all.addAY(c.getValue(), col);
                    }
                    continue;
                }
                cursor.skip(cur.freeCoefficientsCount());
            }
        }
        return TsData.ofInternal((TsPeriod)domain.getStartPeriod(), (double[])all.getStorage());
    }

    public TsData linearizedSeries() {
        TsData interp = this.interpolatedSeries(true);
        if (this.variables.length == 0) {
            return interp;
        }
        DataBlock rslt = DataBlock.of(interp.getValues());
        DoubleSeqCursor c = this.concentratedLikelihood.coefficients().cursor();
        int j = 0;
        if (this.model.isMean()) {
            c.skip(1);
            ++j;
        }
        TsDomain all = interp.getDomain();
        for (int i = j; i < this.variables.length; ++i) {
            FastMatrix xcur = Regression.matrix(all, this.variables[i].getCore());
            DataBlockIterator xcols = xcur.columnsIterator();
            while (xcols.hasNext()) {
                rslt.addAY(-c.getAndNext(), xcols.next());
            }
        }
        return TsData.of((TsPeriod)interp.getStart(), (DoubleSeq)rslt);
    }

    public TsData backTransform(TsData s, boolean includeLp) {
        if (this.logTransformation) {
            s = s.exp();
            if (includeLp && this.lpTransformation != LengthOfPeriodType.None) {
                s = Transformations.lengthOfPeriod(this.lpTransformation).converse().transform(s, null);
            }
        }
        return s;
    }

    public TsData transform(TsData s, boolean includeLp) {
        if (this.logTransformation) {
            if (includeLp && this.lpTransformation != LengthOfPeriodType.None) {
                s = Transformations.lengthOfPeriod(this.lpTransformation).transform(s, null);
            }
            s = s.log();
        }
        return s;
    }

    public TsData fullResiduals() {
        DoubleSeq res = RegArimaUtility.fullResiduals(this.model, this.concentratedLikelihood);
        TsPeriod start = this.transformedSeries.getEnd().plus((long)(-res.length()));
        return TsData.of((TsPeriod)start, (DoubleSeq)res);
    }

    public NiidTests residualsTests() {
        DoubleSeq res = RegArimaUtility.fullResiduals(this.model, this.concentratedLikelihood);
        return NiidTests.builder().data(res).period(this.originalSeries.getAnnualFrequency()).hyperParametersCount(this.freeArimaParametersCount).build();
    }

    public TsData getTradingDaysEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isDaysRelated((Variable)v));
        return this.backTransform(s, true);
    }

    public TsData getEasterEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isEaster((Variable)v));
        return this.backTransform(s, false);
    }

    public TsData getMovingHolidayEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isMovingHoliday((Variable)v));
        return this.backTransform(s, false);
    }

    public TsData getRamadanEffect(TsDomain domain) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TsData getOutliersEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isOutlier((Variable)v));
        return this.backTransform(s, false);
    }

    public TsData getOutliersEffect(TsDomain domain, boolean ami) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isOutlier((Variable)v, (boolean)ami));
        return this.backTransform(s, false);
    }

    public TsData getCalendarEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> ModellingUtility.isCalendar((Variable)v));
        return this.backTransform(s, true);
    }

    public TsData getDeterministicEffect(TsDomain domain) {
        TsData s = this.deterministicEffect(domain, v -> true);
        return this.backTransform(s, true);
    }

    @Generated
    public TsData getOriginalSeries() {
        return this.originalSeries;
    }

    @Generated
    public TsData getTransformedSeries() {
        return this.transformedSeries;
    }

    @Generated
    public TsDomain getEstimationDomain() {
        return this.estimationDomain;
    }

    @Generated
    public boolean isLogTransformation() {
        return this.logTransformation;
    }

    @Generated
    public LengthOfPeriodType getLpTransformation() {
        return this.lpTransformation;
    }

    @Generated
    public int[] getMissing() {
        return this.missing;
    }

    @NonNull
    @Generated
    public Variable[] getVariables() {
        return this.variables;
    }

    @Generated
    public RegArimaModel<SarimaModel> getModel() {
        return this.model;
    }

    @Generated
    public ConcentratedLikelihoodWithMissing getConcentratedLikelihood() {
        return this.concentratedLikelihood;
    }

    @Generated
    public int getFreeArimaParametersCount() {
        return this.freeArimaParametersCount;
    }

    @Generated
    public boolean[] getFixedArimaParameters() {
        return this.fixedArimaParameters;
    }

    @Generated
    public double[] getArimaParameters() {
        return this.arimaParameters;
    }

    @Generated
    public double[] getArimaScore() {
        return this.arimaScore;
    }

    @Generated
    public FastMatrix getArimaCovariance() {
        return this.arimaCovariance;
    }

    @Generated
    public LikelihoodStatistics getStatistics() {
        return this.statistics;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelEstimation)) {
            return false;
        }
        ModelEstimation other = (ModelEstimation)o;
        if (this.isLogTransformation() != other.isLogTransformation()) {
            return false;
        }
        if (this.getFreeArimaParametersCount() != other.getFreeArimaParametersCount()) {
            return false;
        }
        TsData this$originalSeries = this.getOriginalSeries();
        TsData other$originalSeries = other.getOriginalSeries();
        if (this$originalSeries == null ? other$originalSeries != null : !this$originalSeries.equals(other$originalSeries)) {
            return false;
        }
        TsData this$interpolated = this.interpolated;
        TsData other$interpolated = other.interpolated;
        if (this$interpolated == null ? other$interpolated != null : !this$interpolated.equals(other$interpolated)) {
            return false;
        }
        TsData this$transformedSeries = this.getTransformedSeries();
        TsData other$transformedSeries = other.getTransformedSeries();
        if (this$transformedSeries == null ? other$transformedSeries != null : !this$transformedSeries.equals(other$transformedSeries)) {
            return false;
        }
        TsDomain this$estimationDomain = this.getEstimationDomain();
        TsDomain other$estimationDomain = other.getEstimationDomain();
        if (this$estimationDomain == null ? other$estimationDomain != null : !this$estimationDomain.equals(other$estimationDomain)) {
            return false;
        }
        LengthOfPeriodType this$lpTransformation = this.getLpTransformation();
        LengthOfPeriodType other$lpTransformation = other.getLpTransformation();
        if (this$lpTransformation == null ? other$lpTransformation != null : !this$lpTransformation.equals(other$lpTransformation)) {
            return false;
        }
        if (!Arrays.equals(this.getMissing(), other.getMissing())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVariables(), other.getVariables())) {
            return false;
        }
        RegArimaModel<SarimaModel> this$model = this.getModel();
        RegArimaModel<SarimaModel> other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        ConcentratedLikelihoodWithMissing this$concentratedLikelihood = this.getConcentratedLikelihood();
        ConcentratedLikelihoodWithMissing other$concentratedLikelihood = other.getConcentratedLikelihood();
        if (this$concentratedLikelihood == null ? other$concentratedLikelihood != null : !this$concentratedLikelihood.equals(other$concentratedLikelihood)) {
            return false;
        }
        if (!Arrays.equals(this.getFixedArimaParameters(), other.getFixedArimaParameters())) {
            return false;
        }
        if (!Arrays.equals(this.getArimaParameters(), other.getArimaParameters())) {
            return false;
        }
        if (!Arrays.equals(this.getArimaScore(), other.getArimaScore())) {
            return false;
        }
        FastMatrix this$arimaCovariance = this.getArimaCovariance();
        FastMatrix other$arimaCovariance = other.getArimaCovariance();
        if (this$arimaCovariance == null ? other$arimaCovariance != null : !this$arimaCovariance.equals(other$arimaCovariance)) {
            return false;
        }
        LikelihoodStatistics this$statistics = this.getStatistics();
        LikelihoodStatistics other$statistics = other.getStatistics();
        return !(this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLogTransformation() ? 79 : 97);
        result = result * 59 + this.getFreeArimaParametersCount();
        TsData $originalSeries = this.getOriginalSeries();
        result = result * 59 + ($originalSeries == null ? 43 : $originalSeries.hashCode());
        TsData $interpolated = this.interpolated;
        result = result * 59 + ($interpolated == null ? 43 : $interpolated.hashCode());
        TsData $transformedSeries = this.getTransformedSeries();
        result = result * 59 + ($transformedSeries == null ? 43 : $transformedSeries.hashCode());
        TsDomain $estimationDomain = this.getEstimationDomain();
        result = result * 59 + ($estimationDomain == null ? 43 : $estimationDomain.hashCode());
        LengthOfPeriodType $lpTransformation = this.getLpTransformation();
        result = result * 59 + ($lpTransformation == null ? 43 : $lpTransformation.hashCode());
        result = result * 59 + Arrays.hashCode(this.getMissing());
        result = result * 59 + Arrays.deepHashCode(this.getVariables());
        RegArimaModel<SarimaModel> $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        ConcentratedLikelihoodWithMissing $concentratedLikelihood = this.getConcentratedLikelihood();
        result = result * 59 + ($concentratedLikelihood == null ? 43 : $concentratedLikelihood.hashCode());
        result = result * 59 + Arrays.hashCode(this.getFixedArimaParameters());
        result = result * 59 + Arrays.hashCode(this.getArimaParameters());
        result = result * 59 + Arrays.hashCode(this.getArimaScore());
        FastMatrix $arimaCovariance = this.getArimaCovariance();
        result = result * 59 + ($arimaCovariance == null ? 43 : $arimaCovariance.hashCode());
        LikelihoodStatistics $statistics = this.getStatistics();
        result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "ModelEstimation(originalSeries=" + String.valueOf(this.getOriginalSeries()) + ", interpolated=" + String.valueOf(this.interpolated) + ", transformedSeries=" + String.valueOf(this.getTransformedSeries()) + ", estimationDomain=" + String.valueOf(this.getEstimationDomain()) + ", logTransformation=" + this.isLogTransformation() + ", lpTransformation=" + String.valueOf(this.getLpTransformation()) + ", missing=" + Arrays.toString(this.getMissing()) + ", variables=" + Arrays.deepToString(this.getVariables()) + ", model=" + String.valueOf(this.getModel()) + ", concentratedLikelihood=" + String.valueOf(this.getConcentratedLikelihood()) + ", freeArimaParametersCount=" + this.getFreeArimaParametersCount() + ", fixedArimaParameters=" + Arrays.toString(this.getFixedArimaParameters()) + ", arimaParameters=" + Arrays.toString(this.getArimaParameters()) + ", arimaScore=" + Arrays.toString(this.getArimaScore()) + ", arimaCovariance=" + String.valueOf(this.getArimaCovariance()) + ", statistics=" + String.valueOf(this.getStatistics()) + ")";
    }
}

