/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.extractors;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.InformationDelegate;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.MissingValueEstimation;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.RegressionItem;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.UserVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.modelling.regression.RegressionDesc;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import lombok.Generated;

public final class RegSarimaModelExtractors {
    public static final int NFCAST = -1;
    public static final int NBCAST = 0;

    @Generated
    private RegSarimaModelExtractors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class GenericExtractor
    extends InformationDelegate<RegSarimaModel, GeneralLinearModel> {
        public GenericExtractor() {
            super(v -> v);
        }

        public Class<GeneralLinearModel> getDelegateClass() {
            return GeneralLinearModel.class;
        }

        public Class<RegSarimaModel> getSourceClass() {
            return RegSarimaModel.class;
        }
    }

    public static class Specific
    extends InformationMapping<RegSarimaModel> {
        private String arimaItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"arima", key});
        }

        private String regressionItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"regression", key});
        }

        private String advancedItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"regression.details", key});
        }

        private String mlItem(String key) {
            return Dictionary.concatenate((String[])new String[]{"regression.ml", key});
        }

        private RegressionItem phi(RegSarimaModel model, int lag) {
            if (lag <= 0) {
                return null;
            }
            SarimaSpec arima = model.getDescription().getStochasticComponent();
            Parameter[] p = arima.getPhi();
            if (lag > p.length) {
                return null;
            }
            Parameter phi = p[lag - 1];
            if (phi.isFixed()) {
                return new RegressionItem(phi.getValue(), 0.0, Double.NaN, null);
            }
            int pos = 0;
            for (int i = 0; i < p.length && lag != i + 1; ++i) {
                if (p[i].isFixed()) continue;
                ++pos;
            }
            return this.pt(model, phi.getValue(), pos, null);
        }

        private RegressionItem bphi(RegSarimaModel model, int lag) {
            if (lag <= 0) {
                return null;
            }
            SarimaSpec arima = model.getDescription().getStochasticComponent();
            Parameter[] p = arima.getBphi();
            if (lag > p.length) {
                return null;
            }
            Parameter bphi = p[lag - 1];
            if (bphi.isFixed()) {
                return new RegressionItem(bphi.getValue(), 0.0, Double.NaN, null);
            }
            int pos = Parameter.freeParametersCount((Parameter[])arima.getPhi());
            for (int i = 0; i < p.length && lag != i + 1; ++i) {
                if (p[i].isFixed()) continue;
                ++pos;
            }
            return this.pt(model, bphi.getValue(), pos, null);
        }

        private RegressionItem theta(RegSarimaModel model, int lag) {
            if (lag <= 0) {
                return null;
            }
            SarimaSpec arima = model.getDescription().getStochasticComponent();
            Parameter[] p = arima.getTheta();
            if (lag > p.length) {
                return null;
            }
            Parameter theta = p[lag - 1];
            if (theta.isFixed()) {
                return new RegressionItem(theta.getValue(), 0.0, Double.NaN, null);
            }
            int pos = Parameter.freeParametersCount((Parameter[])arima.getPhi()) + Parameter.freeParametersCount((Parameter[])arima.getBphi());
            for (int i = 0; i < p.length && lag != i + 1; ++i) {
                if (p[i].isFixed()) continue;
                ++pos;
            }
            return this.pt(model, theta.getValue(), pos, null);
        }

        private RegressionItem btheta(RegSarimaModel model, int lag) {
            if (lag <= 0) {
                return null;
            }
            SarimaSpec arima = model.getDescription().getStochasticComponent();
            Parameter[] p = arima.getBtheta();
            if (lag > p.length) {
                return null;
            }
            Parameter btheta = p[lag - 1];
            if (btheta.isFixed()) {
                return new RegressionItem(btheta.getValue(), 0.0, Double.NaN, null);
            }
            int pos = Parameter.freeParametersCount((Parameter[])arima.getPhi()) + Parameter.freeParametersCount((Parameter[])arima.getBphi()) + Parameter.freeParametersCount((Parameter[])arima.getTheta());
            for (int i = 0; i < p.length && lag != i + 1; ++i) {
                if (p[i].isFixed()) continue;
                ++pos;
            }
            return this.pt(model, btheta.getValue(), pos, null);
        }

        RegressionItem pt(RegSarimaModel model, double val, int pos, String name) {
            GeneralLinearModel.Estimation estimation = model.getEstimation();
            LikelihoodStatistics ll = estimation.getStatistics();
            int nobs = ll.getEffectiveObservationsCount();
            int nparams = ll.getEstimatedParametersCount();
            int nhp = model.freeArimaParametersCount();
            double ndf = nobs - nparams;
            double vcorr = ndf / (ndf + (double)nhp);
            T t = new T(nobs - nparams);
            double stde = Math.sqrt(estimation.getParameters().getCovariance().get(pos, pos) * vcorr);
            double tval = val / stde;
            double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
            return new RegressionItem(val, stde, prob, name);
        }

        public Specific() {
            this.delegate("arima", SarimaSpec.class, source -> source.getDescription().getStochasticComponent());
            this.setArray(this.arimaItem("phi"), 1, 12, RegressionItem.class, (source, i) -> this.phi((RegSarimaModel)source, (int)i));
            this.setArray(this.arimaItem("bphi"), 1, 12, RegressionItem.class, (source, i) -> this.bphi((RegSarimaModel)source, (int)i));
            this.setArray(this.arimaItem("theta"), 1, 12, RegressionItem.class, (source, i) -> this.theta((RegSarimaModel)source, (int)i));
            this.setArray(this.arimaItem("btheta"), 1, 12, RegressionItem.class, (source, i) -> this.btheta((RegSarimaModel)source, (int)i));
            this.setArray("y_f", -1, TsData.class, (source, i) -> source.forecasts((int)i).getForecasts());
            this.setArray("y_b", 0, TsData.class, (source, i) -> source.backcasts((int)i).getForecasts());
            this.setArray("y_ef", -1, TsData.class, (source, i) -> source.forecasts((int)i).getForecastsStdev());
            this.setArray("y_eb", 0, TsData.class, (source, i) -> source.backcasts((int)i).getForecastsStdev());
            this.set("yc", TsData.class, source -> source.interpolatedSeries(false));
            this.setArray("yc_f", -1, TsData.class, (source, i) -> source.forecasts((int)i).getForecasts());
            this.setArray("yc_b", 0, TsData.class, (source, i) -> source.backcasts((int)i).getForecasts());
            this.set("ylin", TsData.class, source -> {
                TsData lin = source.linearizedSeries();
                return source.backTransform(lin, false);
            });
            this.setArray("ylin_b", 0, TsData.class, (source, i) -> {
                TsData lin = source.linearizedBackcasts((int)i);
                return source.backTransform(lin, false);
            });
            this.setArray("ylin_f", -1, TsData.class, (source, i) -> {
                TsData lin = source.linearizedForecasts((int)i);
                return source.backTransform(lin, false);
            });
            this.set("l", TsData.class, source -> source.linearizedSeries());
            this.setArray("l_b", -1, TsData.class, (source, i) -> source.linearizedBackcasts((int)i));
            this.setArray("l_f", 0, TsData.class, (source, i) -> source.linearizedForecasts((int)i));
            this.set("ycal", TsData.class, source -> {
                TsData y = source.getDescription().getSeries();
                TsData cal = source.getCalendarEffect(y.getDomain());
                return source.inv_op(y, cal);
            });
            this.setArray("ycal_f", -1, TsData.class, (source, i) -> {
                TsDomain fdom = source.forecastDomain((int)i);
                TsData yf = source.forecasts((int)i).getForecasts();
                TsData calf = source.getCalendarEffect(fdom);
                return source.inv_op(yf, calf);
            });
            this.setArray("ycal_b", 0, TsData.class, (source, i) -> {
                TsDomain fdom = source.backcastDomain((int)i);
                TsData yf = source.backcasts((int)i).getForecasts();
                TsData calf = source.getCalendarEffect(fdom);
                return source.inv_op(yf, calf);
            });
            this.set("ycal", TsData.class, source -> {
                TsData y = source.getDescription().getSeries();
                TsData cal = source.getCalendarEffect(y.getDomain());
                return source.inv_op(y, cal);
            });
            this.set("det", TsData.class, source -> {
                TsData det = source.deterministicEffect(null, v -> !(v.getCore() instanceof TrendConstant));
                return source.backTransform(det, true);
            });
            this.setArray("det_f", -1, TsData.class, (source, i) -> {
                TsData det = source.deterministicEffect(source.forecastDomain((int)i), v -> !(v.getCore() instanceof TrendConstant));
                return source.backTransform(det, true);
            });
            this.setArray("det_b", 0, TsData.class, (source, i) -> {
                TsData det = source.deterministicEffect(source.backcastDomain((int)i), v -> !(v.getCore() instanceof TrendConstant));
                return source.backTransform(det, true);
            });
            this.set("cal", TsData.class, source -> source.getCalendarEffect(null));
            this.setArray("cal_f", -1, TsData.class, (source, i) -> source.getCalendarEffect(source.forecastDomain((int)i)));
            this.setArray("cal_b", 0, TsData.class, (source, i) -> source.getCalendarEffect(source.backcastDomain((int)i)));
            this.set("tde", TsData.class, source -> source.getTradingDaysEffect(null));
            this.setArray("tde_f", -1, TsData.class, (source, i) -> source.getTradingDaysEffect(source.forecastDomain((int)i)));
            this.setArray("tde_b", 0, TsData.class, (source, i) -> source.getTradingDaysEffect(source.backcastDomain((int)i)));
            this.set("mhe", TsData.class, source -> source.getMovingHolidayEffect(null));
            this.setArray("mhe_f", -1, TsData.class, (source, i) -> source.getMovingHolidayEffect(source.forecastDomain((int)i)));
            this.setArray("mhe_b", 0, TsData.class, (source, i) -> source.getMovingHolidayEffect(source.backcastDomain((int)i)));
            this.set("ee", TsData.class, source -> source.getEasterEffect(null));
            this.setArray("ee_f", -1, TsData.class, (source, i) -> source.getEasterEffect(source.forecastDomain((int)i)));
            this.setArray("ee_b", 0, TsData.class, (source, i) -> source.getEasterEffect(source.backcastDomain((int)i)));
            this.set("omhe", TsData.class, source -> source.getOtherMovingHolidayEffect(null));
            this.setArray("omhe_f", -1, TsData.class, (source, i) -> source.getOtherMovingHolidayEffect(source.forecastDomain((int)i)));
            this.setArray("omhe_b", 0, TsData.class, (source, i) -> source.getOtherMovingHolidayEffect(source.backcastDomain((int)i)));
            this.set("out", TsData.class, source -> source.getOutliersEffect(null));
            this.setArray("out_f", -1, TsData.class, (source, i) -> source.getOutliersEffect(source.forecastDomain((int)i)));
            this.setArray("out_b", 0, TsData.class, (source, i) -> source.getOutliersEffect(source.backcastDomain((int)i)));
            this.set(this.regressionItem("mu"), RegressionItem.class, source -> source.regressionItem(v -> v instanceof TrendConstant, 0));
            this.set(this.regressionItem("lp"), RegressionItem.class, source -> source.regressionItem(v -> v instanceof ILengthOfPeriodVariable, 0));
            this.set(this.regressionItem("easter"), RegressionItem.class, source -> source.regressionItem(v -> v instanceof IEasterVariable, 0));
            this.setArray(this.regressionItem("outlier"), 1, 31, RegressionItem.class, (source, i) -> source.regressionItem(v -> v instanceof IOutlier, i - 1));
            this.setArray(this.regressionItem("td"), 1, 7, RegressionItem.class, (source, i) -> source.regressionItem(v -> v instanceof ITradingDaysVariable, i - 1));
            this.setArray(this.regressionItem("user"), 1, 30, RegressionItem.class, (source, i) -> source.regressionItem(v -> v instanceof UserVariable, i - 1));
            this.setArray(this.regressionItem("out"), 1, 30, RegressionItem.class, (source, i) -> source.regressionItem(v -> v instanceof IOutlier, i - 1));
            this.setArray(this.regressionItem("missing"), 1, 100, MissingValueEstimation.class, (source, i) -> {
                MissingValueEstimation[] missing = source.getEstimation().getMissing();
                return i <= 0 || i > missing.length ? null : missing[i - 1];
            });
            this.set("full_res", TsData.class, source -> source.fullResiduals());
            this.set("reg", TsData.class, source -> {
                TsData reg = source.deterministicEffect(null, v -> !ModellingUtility.isCalendar((Variable)v) && !ModellingUtility.isOutlier((Variable)v));
                return source.backTransform(reg, false);
            });
            this.setArray("reg_f", -1, TsData.class, (source, i) -> {
                TsData reg = source.deterministicEffect(source.forecastDomain((int)i), v -> !ModellingUtility.isCalendar((Variable)v) && !ModellingUtility.isOutlier((Variable)v));
                return source.backTransform(reg, false);
            });
            this.setArray("reg_b", 0, TsData.class, (source, i) -> {
                TsData reg = source.deterministicEffect(source.backcastDomain((int)i), v -> !ModellingUtility.isCalendar((Variable)v) && !ModellingUtility.isOutlier((Variable)v));
                return source.backTransform(reg, false);
            });
            this.set(this.regressionItem("td-derived"), RegressionItem.class, source -> {
                RegressionDesc desc = source.getDetails().getDerivedTradingDay();
                if (desc == null) {
                    return null;
                }
                return new RegressionItem(desc.getCoef(), desc.getStderr(), desc.getPvalue(), desc.getName());
            });
            this.set(this.regressionItem("td-ftest"), StatisticalTest.class, source -> source.getDetails().getFTestonTradingDays());
            this.set(this.advancedItem("description"), String[].class, source -> (String[])source.getDetails().getRegressionItems().stream().map(r -> r.getName()).toArray(String[]::new));
            this.set(this.mlItem("pcorr"), Matrix.class, source -> {
                FastMatrix cov = FastMatrix.of(source.getEstimation().getParameters().getCovariance());
                DataBlock diag = cov.diagonal();
                for (int i = 0; i < cov.getRowsCount(); ++i) {
                    double vi = diag.get(i);
                    for (int j = 0; j < i; ++j) {
                        double vj = diag.get(j);
                        if (vi == 0.0 || vj == 0.0) continue;
                        cov.mul(i, j, 1.0 / Math.sqrt(vi * vj));
                    }
                }
                SymmetricMatrix.fromLower(cov);
                diag.set(1.0);
                return cov;
            });
        }

        public Class<RegSarimaModel> getSourceClass() {
            return RegSarimaModel.class;
        }
    }
}

