/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.estimation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaEstimation;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaFunction;
import jdplus.toolkit.base.core.regarima.estimation.RegArmaSsqFunction;
import jdplus.toolkit.base.core.stats.likelihood.DefaultLikelihoodEvaluation;
import lombok.NonNull;

public class RegArmaProcessor {
    private final boolean ml;
    private final boolean mt;
    private final boolean fast;

    public RegArmaProcessor(boolean ml, boolean mt, boolean fastDerivatives) {
        this.ml = ml;
        this.mt = mt;
        this.fast = fastDerivatives;
    }

    public <S extends IArimaModel> RegArmaEstimation<S> compute(@NonNull RegArmaModel<S> model, @NonNull DoubleSeq start, IArimaMapping<S> mapping, SsqFunctionMinimizer minimizer, int ndf) {
        double objective;
        FastMatrix hessian;
        double[] gradient;
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        RegArmaSsqFunction fn = RegArmaSsqFunction.builder(model.getY()).variables(model.getX()).missingCount(model.getMissingCount()).mapping(mapping).maximumLikelihood(this.ml).parallelProcessing(this.mt).build();
        boolean ok = minimizer.minimize(fn.ssqEvaluate(start));
        RegArmaSsqFunction.Evaluation rslt = (RegArmaSsqFunction.Evaluation)minimizer.getResult();
        if (this.fast) {
            gradient = minimizer.gradientAtMinimum().toArray();
            hessian = minimizer.curvatureAtMinimum();
            objective = rslt.getSsqE();
        } else {
            DataBlock res = model.asLinearModel().calcResiduals(rslt.allCoefficients());
            int nm = model.getMissingCount();
            FastMatrix xm = FastMatrix.EMPTY;
            if (nm > 0) {
                FastMatrix x = model.getX();
                xm = x.extract(0, x.getRowsCount(), 0, nm);
            }
            RegArmaFunction fnr = RegArmaFunction.builder((DoubleSeq)res).variables(xm).missingCount(nm).mapping(mapping).likelihoodEvaluation(DefaultLikelihoodEvaluation.deviance()).build();
            IFunctionPoint eval = fnr.evaluate(rslt.getParameters());
            IFunctionDerivatives derivatives = eval.derivatives();
            gradient = derivatives.gradient().toArray();
            hessian = derivatives.hessian();
            objective = ((RegArmaFunction.Evaluation)eval).getValue();
        }
        hessian.mul(0.5 * (double)ndf / objective);
        int i = 0;
        while (i < gradient.length) {
            int n = i++;
            gradient[n] = gradient[n] * (-0.5 * (double)ndf / objective);
        }
        RegArmaModel<S> nmodel = RegArmaModel.of(model, rslt.arma);
        return new RegArmaEstimation(rslt.getParameters(), DoubleSeq.of((double[])gradient), hessian);
    }
}

