/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.ami;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.TransitoryChangeFactory;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.ami.GenericOutliersDetection;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regarima.outlier.CriticalValueComputer;
import jdplus.toolkit.base.core.regarima.outlier.FastOutlierDetector;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

public class OutliersDetectionModule<T extends IArimaModel>
implements GenericOutliersDetection<T> {
    public static int DEF_MAXROUND = 100;
    public static int DEF_MAXOUTLIERS = 50;
    private RegArimaModel<T> regarima;
    private ConcentratedLikelihoodWithMissing cll;
    private final ArrayList<int[]> outliers = new ArrayList();
    private final SingleOutlierDetector<T> sod;
    private final IRegArimaComputer<T> processor;
    private final int maxOutliers;
    private final int maxRound;
    private int nhp;
    private int round;
    private boolean exit;
    private int[] lastremoved;
    private double cv;
    public static final double MINCV = 2.0;
    private Consumer<int[]> addHook;
    private Consumer<int[]> removeHook;

    public static <T extends IArimaModel> Builder<T> build(Class<T> tclass) {
        return new Builder();
    }

    private OutliersDetectionModule(SingleOutlierDetector sod, IRegArimaComputer<T> processor, int maxOutliers, int maxRound) {
        this.sod = sod;
        this.processor = processor;
        this.maxOutliers = maxOutliers;
        this.maxRound = maxRound;
    }

    public RegArimaModel<T> getRegarima() {
        return this.regarima;
    }

    @Override
    public int[][] getOutliers() {
        return (int[][])this.outliers.toArray(x$0 -> new int[x$0][]);
    }

    public Consumer<int[]> getAddHook() {
        return this.addHook;
    }

    public void setAddHook(Consumer<int[]> addHook) {
        this.addHook = addHook;
    }

    public Consumer<int[]> getRemoveHook() {
        return this.removeHook;
    }

    public void setRemoveHook(Consumer<int[]> removeHook) {
        this.removeHook = removeHook;
    }

    @Override
    public boolean process(RegArimaModel<T> initialModel, IArimaMapping<T> mapping) {
        this.clear();
        this.regarima = initialModel;
        this.nhp = 0;
        if (!this.estimateModel(mapping, true)) {
            return false;
        }
        try {
            this.calc(mapping);
            return true;
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    @Override
    public void prepare(int n) {
        this.sod.prepare(n);
    }

    @Override
    public void setBounds(int start, int end) {
        this.sod.setBounds(start, end);
    }

    private void calc(IArimaMapping<T> mapping) {
        this.exit = false;
        while (this.sod.process(this.regarima)) {
            ++this.round;
            double max = this.sod.getMaxTStat();
            if (Math.abs(max) < this.cv) break;
            int type = this.sod.getMaxOutlierType();
            int pos = this.sod.getMaxOutlierPosition();
            this.addOutlier(pos, type);
            this.estimateModel(mapping, false);
            if (!this.verifyModel()) {
                this.cll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(this.regarima);
                if (this.exit) break;
            }
            if (this.round <= this.maxRound && this.outliers.size() <= this.maxOutliers) continue;
        }
        while (!this.verifyModel()) {
            this.cll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(this.regarima);
        }
    }

    private boolean estimateModel(IArimaMapping<T> mapping, boolean full) {
        RegArimaEstimation<T> est = full ? this.processor.process(this.regarima, mapping) : this.processor.optimize(this.regarima, mapping);
        this.regarima = est.getModel();
        this.cll = est.getConcentratedLikelihood();
        return true;
    }

    private void clear() {
        this.cll = null;
        this.regarima = null;
        this.nhp = 0;
        this.outliers.clear();
        this.round = 0;
        this.lastremoved = null;
    }

    private boolean verifyModel() {
        if (this.outliers.isEmpty()) {
            return true;
        }
        int nx0 = this.regarima.getVariablesCount() - this.outliers.size();
        int imin = 0;
        double tmin = Math.abs(this.cll.tstat(nx0, this.nhp, true));
        for (int i = 1; i < this.outliers.size(); ++i) {
            double tcur = Math.abs(this.cll.tstat(i + nx0, this.nhp, true));
            if (!(tcur < tmin)) continue;
            imin = i;
            tmin = tcur;
        }
        if (tmin >= this.cv) {
            return true;
        }
        int[] toremove = this.outliers.get(imin);
        this.sod.allow(toremove[0], toremove[1]);
        this.removeOutlier(imin);
        if (this.removeHook != null) {
            this.removeHook.accept(toremove);
        }
        if (this.lastremoved != null && Arrays.equals(toremove, this.lastremoved)) {
            this.exit = true;
        }
        this.lastremoved = toremove;
        return false;
    }

    private void addOutlier(int pos, int type) {
        int[] o = new int[]{pos, type};
        this.outliers.add(o);
        double[] xo = new double[this.regarima.getObservationsCount()];
        DataBlock XO = DataBlock.of(xo);
        this.sod.getOutlierFactory(type).fill(pos, XO);
        this.regarima = this.regarima.toBuilder().addX((DoubleSeq)XO).build();
        this.cll = null;
        this.sod.exclude(pos, type);
        if (this.addHook != null) {
            this.addHook.accept(o);
        }
    }

    private void removeOutlier(int idx) {
        int opos = this.regarima.getX().size() - this.outliers.size() + idx;
        this.regarima = this.regarima.toBuilder().removeX(opos).build();
        this.cll = null;
        this.outliers.remove(idx);
    }

    public void setCriticalValue(double value) {
        this.cv = value;
    }

    public double getCritivalValue() {
        return this.cv;
    }

    public static double calcCv(int nobs) {
        return Math.max(CriticalValueComputer.simpleComputer().applyAsDouble(nobs), 2.0);
    }

    @Override
    public void exclude(int pos, int type) {
        this.sod.exclude(pos, type);
    }

    public IOutlierFactory getFactory(int i) {
        return this.sod.getOutlierFactory(i);
    }

    public static class Builder<T extends IArimaModel> {
        private SingleOutlierDetector<T> sod = new FastOutlierDetector(null);
        private IRegArimaComputer<T> processor;
        private int maxOutliers = DEF_MAXOUTLIERS;
        private int maxRound = DEF_MAXROUND;
        private final List<IOutlierFactory> factories = new ArrayList<IOutlierFactory>();

        public Builder<T> detector(SingleOutlierDetector<T> sod) {
            this.sod = sod;
            return this;
        }

        public Builder<T> processor(IRegArimaComputer<T> processor) {
            this.processor = processor;
            return this;
        }

        public Builder<T> maxOutliers(int max) {
            this.maxOutliers = max;
            return this;
        }

        public Builder<T> maxRound(int max) {
            this.maxRound = max;
            return this;
        }

        public Builder<T> addFactory(IOutlierFactory factory) {
            this.factories.add(factory);
            return this;
        }

        public Builder<T> addFactories(IOutlierFactory[] factories) {
            if (factories != null) {
                for (int i = 0; i < factories.length; ++i) {
                    this.factories.add(factories[i]);
                }
            }
            return this;
        }

        public Builder<T> setDefault() {
            this.factories.clear();
            this.factories.add(AdditiveOutlierFactory.FACTORY);
            this.factories.add(LevelShiftFactory.FACTORY_ZEROENDED);
            return this;
        }

        public Builder<T> setAll() {
            this.setDefault();
            this.factories.add(new TransitoryChangeFactory(0.7));
            return this;
        }

        public Builder<T> setAll(int period) {
            this.setAll();
            this.factories.add(new PeriodicOutlierFactory(period, true));
            return this;
        }

        public OutliersDetectionModule build() {
            this.sod.setOutlierFactories((IOutlierFactory[])this.factories.toArray(IOutlierFactory[]::new));
            return new OutliersDetectionModule<T>(this.sod, this.processor, this.maxOutliers, this.maxRound);
        }
    }
}

