/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.regular.IModelComparator;

public class AICcComparator
implements IModelComparator {
    private final double aicDiff;

    public AICcComparator(double aiccDiff) {
        this.aicDiff = aiccDiff;
    }

    @Override
    public <M extends IArimaModel> int compare(RegArimaEstimation<M> reference, RegArimaEstimation<M>[] models) {
        int imin = -1;
        double aicc = 0.0;
        for (int i = 0; i < models.length; ++i) {
            if (models[i] == null) continue;
            double aiccCur = models[i].statistics().getAICC();
            if (imin >= 0 && !(aiccCur < aicc)) continue;
            aicc = aiccCur;
            imin = i;
        }
        if (imin < 0) {
            return -1;
        }
        if (reference == null) {
            return imin;
        }
        double aiccRef = reference.statistics().getAICC();
        return aicc < aiccRef - this.aicDiff ? imin : -1;
    }

    @Override
    public <M extends IArimaModel> int compare(RegArimaEstimation<M> reference, RegArimaEstimation<M> alternative) {
        if (reference == null) {
            return 0;
        }
        if (alternative == null) {
            return -1;
        }
        double aiccRef = reference.statistics().getAICC();
        double aicc = alternative.statistics().getAICC();
        return aicc < aiccRef - this.aicDiff ? 0 : -1;
    }
}

