/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.SwitchOutlier;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class WOFactory
implements RegressionVariableFactory<SwitchOutlier> {
    static WOFactory FACTORY = new WOFactory();

    private WOFactory() {
    }

    @Override
    public boolean fill(SwitchOutlier var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        TsPeriod p = start.withDate(var.getPosition());
        this.set(buffer.column(0), start.until(p));
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(SwitchOutlier var, D domain, FastMatrix buffer, ProcessingLog log) {
        this.set(buffer.column(0), domain.indexOf(var.getPosition()));
        return true;
    }

    private void set(DataBlock z, int opos) {
        int last = z.length() - 1;
        if (opos < -1 || opos > last) {
            return;
        }
        if (opos == -1) {
            z.set(0, -1.0);
        } else if (opos == last) {
            z.set(last, 1.0);
        } else {
            z.set(opos, 1.0);
            z.set(opos + 1, -1.0);
        }
    }
}

