/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.TrigonometricVariables;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

public class TrigonometricVariablesFactory
implements RegressionVariableFactory<TrigonometricVariables> {
    static TrigonometricVariablesFactory FACTORY = new TrigonometricVariablesFactory();

    public static FastMatrix matrix(TrigonometricVariables var, int length, int start) {
        double[] freq = var.getFrequencies();
        FastMatrix m = FastMatrix.make(length, var.dim());
        int nlast = freq.length - 1;
        if (freq[nlast] != 1.0) {
            ++nlast;
        }
        for (int i = 0; i < nlast; ++i) {
            double w = freq[i] * Math.PI;
            DataBlock c = m.column(2 * i);
            c.set(k -> Math.cos(w * (double)(k + start)));
            DataBlock s = m.column(2 * i + 1);
            s.set(k -> Math.sin(w * (double)(k + start)));
        }
        if (nlast < freq.length) {
            DataBlock c = m.column(2 * nlast);
            c.set(k -> (k + start) % 2 == 0 ? 1.0 : -1.0);
        }
        return m;
    }

    private TrigonometricVariablesFactory() {
    }

    @Override
    public boolean fill(TrigonometricVariables var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int nlast;
        TsPeriod refPeriod = start.withDate(var.getReference());
        long istart = start.getId() - refPeriod.getId();
        double[] freq = var.getFrequencies();
        if (freq[nlast = freq.length - 1] != 1.0) {
            ++nlast;
        }
        for (int i = 0; i < nlast; ++i) {
            double w = freq[i] * Math.PI;
            DataBlock c = buffer.column(2 * i);
            c.set(k -> Math.cos(w * (double)((long)k + istart)));
            DataBlock s = buffer.column(2 * i + 1);
            s.set(k -> Math.sin(w * (double)((long)k + istart)));
        }
        if (nlast < freq.length) {
            DataBlock c = buffer.column(2 * nlast);
            c.set(k -> ((long)k + istart) % 2L == 0L ? 1.0 : -1.0);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(TrigonometricVariables var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

