/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;

public class TransitoryChangeFactory
implements IOutlierFactory {
    private final double coefficient;
    static double ZERO = 1.0E-15;

    public static double rate(int period, double monthlyRate) {
        if (period == 12) {
            return monthlyRate;
        }
        if (12 % period != 0) {
            throw new TsException("Invalid frequnecy");
        }
        return Math.pow(monthlyRate, 12 / period);
    }

    public TransitoryChangeFactory(double coefficient) {
        this.coefficient = coefficient;
    }

    public TransitoryChange make(LocalDateTime position) {
        return new TransitoryChange(position, this.coefficient);
    }

    @Override
    public void fill(int outlierPosition, DataBlock buffer) {
        double cur = 1.0;
        int n = buffer.length();
        for (int pos = outlierPosition; pos < n; ++pos) {
            buffer.set(pos, cur);
            cur *= this.coefficient;
            if (!(Math.abs(cur) < ZERO)) continue;
            return;
        }
    }

    @Override
    public IOutlierFactory.FilterRepresentation getFilterRepresentation() {
        return new IOutlierFactory.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, BackFilter.ofInternal(1.0, -this.coefficient), 0), 0.0);
    }

    @Override
    public int excludingZoneAtStart() {
        return 0;
    }

    @Override
    public int excludingZoneAtEnd() {
        return 1;
    }

    @Override
    public String getCode() {
        return "TC";
    }
}

