/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class TCFactory
implements RegressionVariableFactory<TransitoryChange> {
    static double ZERO = 1.0E-15;
    static TCFactory FACTORY = new TCFactory();

    private TCFactory() {
    }

    @Override
    public boolean fill(TransitoryChange var, TsPeriod start, FastMatrix m, ProcessingLog log) {
        TsPeriod p = start.withDate(var.getPosition());
        this.fill(var, start.until(p), m.column(0));
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(TransitoryChange var, D domain, FastMatrix m, ProcessingLog log) {
        this.fill(var, domain.indexOf(var.getPosition()), m.column(0));
        return true;
    }

    public void fill(TransitoryChange var, int xpos, DataBlock buffer) {
        double cur = 1.0;
        int n = buffer.length();
        for (int pos = xpos; pos < n; ++pos) {
            if (pos >= 0) {
                buffer.set(pos, cur);
            }
            if (!(Math.abs(cur *= var.getRate()) < ZERO)) continue;
            return;
        }
    }
}

