/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

public class PeriodicContrastsFactory
implements RegressionVariableFactory<PeriodicContrasts> {
    static PeriodicContrastsFactory FACTORY = new PeriodicContrastsFactory();

    public static FastMatrix matrix(PeriodicContrasts var, int length, int start) {
        int period = var.getPeriod();
        FastMatrix M = FastMatrix.make(length, period - 1);
        int lstart = period - start - 1;
        if (lstart < 0) {
            lstart += period;
        }
        for (int i = 0; i < period - 1; ++i) {
            DataBlock x = M.column(i);
            int jstart = i - start;
            if (jstart < 0) {
                jstart += period;
            }
            DataBlock m = x.extract(jstart, -1, period);
            m.set(1.0);
            DataBlock q = x.extract(lstart, -1, period);
            q.set(-1.0);
        }
        return M;
    }

    private PeriodicContrastsFactory() {
    }

    @Override
    public boolean fill(PeriodicContrasts var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int period = var.getPeriod();
        TsPeriod refPeriod = start.withDate(var.getReference());
        long del = start.getId() - refPeriod.getId();
        int pstart = (int)del % period;
        int lstart = period - pstart - 1;
        if (lstart < 0) {
            lstart += period;
        }
        for (int i = 0; i < period - 1; ++i) {
            DataBlock x = buffer.column(i);
            int jstart = i - pstart;
            if (jstart < 0) {
                jstart += period;
            }
            DataBlock m = x.extract(jstart, -1, period);
            m.set(1.0);
            DataBlock q = x.extract(lstart, -1, period);
            q.set(-1.0);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(PeriodicContrasts var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

