/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.regression.MovingHolidayVariable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.MovingHolidayProvider;
import jdplus.toolkit.base.core.modelling.regression.MovingHolidayProviderLoader;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

public class MovingHolidayFactory
implements RegressionVariableFactory<MovingHolidayVariable> {
    private static final List<MovingHolidayProvider> PROVIDERS = MovingHolidayProviderLoader.load();
    static MovingHolidayFactory FACTORY = new MovingHolidayFactory();

    private static MovingHolidayProvider find(String id) {
        Optional<MovingHolidayProvider> provider = PROVIDERS.stream().filter(p -> p.identifier().equals(id)).findFirst();
        return provider.orElse(null);
    }

    @Override
    public boolean fill(MovingHolidayVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        MovingHolidayProvider provider = MovingHolidayFactory.find(var.getEvent());
        if (provider == null) {
            return false;
        }
        DataBlock data = buffer.column(0);
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)buffer.getRowsCount());
        TsUnit unit = domain.getTsUnit();
        if (unit.getChronoUnit().isTimeBased()) {
            return false;
        }
        double[] w = var.getPattern().getWeights();
        int hstart = var.getPattern().getStart();
        LocalDate sd = domain.start().toLocalDate();
        LocalDate ed = domain.end().toLocalDate();
        LocalDate[] holidays = provider.holidays(sd.plusDays(-hstart - w.length), ed.plusDays(-hstart));
        double all = var.getPattern().sum();
        for (int i = 0; i < holidays.length; ++i) {
            int epos;
            LocalDate dhstart = holidays[i].plusDays(hstart);
            LocalDate dhend = holidays[i].plusDays(w.length + hstart);
            if (!sd.isBefore(dhend)) continue;
            if (!dhstart.isBefore(ed)) break;
            TsPeriod pstart = TsPeriod.of((TsUnit)unit, (LocalDate)dhstart);
            TsPeriod pend = TsPeriod.of((TsUnit)unit, (LocalDate)dhend);
            int spos = domain.indexOf(pstart);
            if (spos == (epos = domain.indexOf(pend)) && spos >= 0) {
                data.set(spos, all);
                continue;
            }
            int ibeg = 0;
            int iend = 0;
            LocalDate cur = dhstart;
            if (spos < 0) {
                iend = ibeg = (int)cur.until(sd, ChronoUnit.DAYS);
                cur = sd;
                spos = 0;
            }
            if (epos < 0) {
                epos = domain.getLength();
            }
            for (int k = spos; k < epos; ++k) {
                LocalDate next = domain.get(k + 1).start().toLocalDate();
                iend = (int)cur.until(next, ChronoUnit.DAYS);
                if (iend > w.length) {
                    data.set(k, MovingHolidayFactory.sum(w, ibeg, w.length));
                    iend = w.length;
                    break;
                }
                data.set(k, MovingHolidayFactory.sum(w, ibeg, iend));
                ibeg = iend;
                cur = next;
            }
            if (iend >= w.length || epos >= domain.getLength()) continue;
            data.set(epos, MovingHolidayFactory.sum(w, iend, w.length));
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(MovingHolidayVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static double sum(double[] w, int start, int end) {
        double s = 0.0;
        for (int i = start; i < end; ++i) {
            s += w[i];
        }
        return s;
    }
}

