/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModifiedTsVariable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.ModifierFactory;
import jdplus.toolkit.base.core.modelling.regression.Modifiers;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class ModifiedTsVariableFactory
implements RegressionVariableFactory<ModifiedTsVariable> {
    static ModifiedTsVariableFactory FACTORY = new ModifiedTsVariableFactory();

    private ModifiedTsVariableFactory() {
    }

    @Override
    public boolean fill(ModifiedTsVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        ITsVariable core = var.getVariable();
        List modifiers = var.getModifiers();
        ArrayList<TsDomain> doms = new ArrayList<TsDomain>();
        TsDomain cur = TsDomain.of((TsPeriod)start, (int)buffer.getRowsCount());
        for (ModifiedTsVariable.Modifier modifier : modifiers) {
            doms.add(cur);
            ModifierFactory factory = Modifiers.factoryFor(modifier);
            if (factory == null) {
                return false;
            }
            cur = factory.needFor(modifier, cur);
        }
        int dim = core.dim();
        FastMatrix input = FastMatrix.make(cur.getLength(), dim);
        RegressionVariableFactory vfactory = Regression.factoryFor(core);
        if (vfactory == null) {
            return false;
        }
        vfactory.fill(core, cur.getStartPeriod(), input);
        for (int i = modifiers.size() - 1; i > 0; --i) {
            ModifiedTsVariable.Modifier modifier = (ModifiedTsVariable.Modifier)modifiers.get(i);
            TsDomain dom = (TsDomain)doms.get(i);
            dim = modifier.redim(dim);
            FastMatrix output = FastMatrix.make(dom.getLength(), dim);
            ModifierFactory factory = Modifiers.factoryFor(modifier);
            if (!factory.fill(modifier, dom.getStartPeriod(), input, output)) {
                return false;
            }
            input = output;
        }
        ModifiedTsVariable.Modifier modifier = (ModifiedTsVariable.Modifier)modifiers.get(0);
        ModifierFactory factory = Modifiers.factoryFor(modifier);
        factory.fill(modifier, start, input, buffer);
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(ModifiedTsVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

