/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;

public class LevelShiftFactory
implements IOutlierFactory {
    public static final LevelShiftFactory FACTORY_ZEROENDED = new LevelShiftFactory(true);
    public static final LevelShiftFactory FACTORY_ZEROSTARTED = new LevelShiftFactory(false);
    private final boolean zeroEnded;

    private LevelShiftFactory(boolean zeroEnded) {
        this.zeroEnded = zeroEnded;
    }

    public boolean isZeroEnded() {
        return this.zeroEnded;
    }

    public LevelShift make(LocalDateTime position) {
        return new LevelShift(position, this.zeroEnded);
    }

    @Override
    public void fill(int xpos, DataBlock buffer) {
        int n = buffer.length();
        double Zero = this.zeroEnded ? -1.0 : 0.0;
        double One = this.zeroEnded ? 0.0 : 1.0;
        buffer.range(0, xpos).set(Zero);
        buffer.range(xpos, n).set(One);
    }

    @Override
    public IOutlierFactory.FilterRepresentation getFilterRepresentation() {
        return new IOutlierFactory.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, BackFilter.D1, 0), this.zeroEnded ? -1.0 : 0.0);
    }

    @Override
    public int excludingZoneAtStart() {
        return 1;
    }

    @Override
    public int excludingZoneAtEnd() {
        return 1;
    }

    @Override
    public String getCode() {
        return "LS";
    }
}

