/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class RangeMeanTest {
    private int groupLength;
    private int trim;

    public RangeMeanTest groupSize(int n) {
        this.groupLength = n;
        return this;
    }

    public RangeMeanTest trim(int n) {
        this.trim = n;
        return this;
    }

    public LeastSquaresResults process(DoubleSeq data) {
        if (data.anyMatch(x -> x <= 0.0)) {
            return null;
        }
        if (this.groupLength == 0) {
            throw new IllegalArgumentException();
        }
        return this.compute(data);
    }

    public static int computeDefaultGroupSize(int period, int n) {
        switch (period) {
            case 6: 
            case 12: {
                return 12;
            }
            case 4: {
                return n > 165 ? 8 : 12;
            }
            case 3: {
                return n > 165 ? 6 : 12;
            }
            case 2: {
                return n > 165 ? 6 : 12;
            }
            case 1: {
                return n > 165 ? 5 : 9;
            }
        }
        return period;
    }

    public LeastSquaresResults compute(DoubleSeq data) {
        int n = data.length();
        int npoints = n / this.groupLength;
        if (npoints <= 3 && this.groupLength == 0) {
            throw new IllegalArgumentException("Not enough data");
        }
        double[] range = new double[npoints];
        double[] smean = new double[npoints];
        double[] srt = new double[this.groupLength];
        for (int i = 0; i < npoints; ++i) {
            for (int j = 0; j < this.groupLength; ++j) {
                srt[j] = data.get(j + i * this.groupLength);
            }
            Arrays.sort(srt);
            range[i] = srt[this.groupLength - this.trim - 1] - srt[this.trim];
            double s = srt[this.trim];
            for (int j = this.trim + 1; j < this.groupLength - this.trim; ++j) {
                s += srt[j];
            }
            smean[i] = s /= (double)(this.groupLength - 2 * this.trim);
        }
        try {
            LinearModel model = LinearModel.builder().y(DoubleSeq.of((double[])range)).addX(DoubleSeq.of((double[])smean)).meanCorrection(true).build();
            return Ols.compute(model);
        }
        catch (Exception err) {
            return null;
        }
    }
}

