/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ml;

import java.util.Random;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.ml.IsolationForests;
import lombok.Generated;

final class IsolationForest {
    static IsolationForests.TreeBuilder BUILDER = (X, selection, limit, rnd) -> new Builder(X, limit, rnd).root(selection);

    @Generated
    private IsolationForest() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Builder {
        final Matrix X;
        final double limit;
        final Random rnd;

        IsolationForests.Node root(int[] selection) {
            int[] sel = selection;
            if (sel == null) {
                sel = new int[this.X.getColumnsCount()];
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = i;
                }
            }
            return this.node(sel, 0);
        }

        IsolationForests.Node node(int[] items, int level) {
            double xmin;
            int size = items.length;
            int dim = this.X.getRowsCount();
            int axis = this.rnd.nextInt(dim);
            DoubleSeq row = this.X.row(axis);
            double xmax = xmin = row.get(items[0]);
            for (int i = 1; i < size; ++i) {
                double r = row.get(items[i]);
                if (r < xmin) {
                    xmin = r;
                    continue;
                }
                if (!(r > xmax)) continue;
                xmax = r;
            }
            double p = xmin + this.rnd.nextDouble() * (xmax - xmin);
            IntList XL = new IntList(size);
            IntList XR = new IntList(size);
            for (int i = 0; i < size; ++i) {
                double r = row.get(items[i]);
                if (r < p) {
                    XL.add(i);
                    continue;
                }
                XR.add(i);
            }
            IsolationForests.Node left = (double)level > this.limit || XL.size() <= 1 ? IsolationForests.FinalNode.of(XL.size()) : this.node(XL.toArray(), level + 1);
            IsolationForests.Node right = (double)level > this.limit || XR.size() <= 1 ? IsolationForests.FinalNode.of(XR.size()) : this.node(XR.toArray(), level + 1);
            return new INode(items, axis, p, left, right);
        }

        @Generated
        public Builder(Matrix X, double limit, Random rnd) {
            this.X = X;
            this.limit = limit;
            this.rnd = rnd;
        }
    }

    static class INode
    implements IsolationForests.Node {
        final int[] items;
        final int axis;
        final double threshold;
        final IsolationForests.Node left;
        final IsolationForests.Node right;

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public int size() {
            return this.items.length;
        }

        @Override
        public IsolationForests.Node branch(DoubleSeq x) {
            if (x.get(this.axis) < this.threshold) {
                return this.left;
            }
            return this.right;
        }

        @Override
        public IsolationForests.Node left() {
            return this.left;
        }

        @Override
        public IsolationForests.Node right() {
            return this.right;
        }

        @Generated
        INode(int[] items, int axis, double threshold, IsolationForests.Node left, IsolationForests.Node right) {
            this.items = items;
            this.axis = axis;
            this.threshold = threshold;
            this.left = left;
            this.right = right;
        }
    }
}

