/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ml;

import java.util.Random;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ml.IsolationForests;
import lombok.Generated;

public final class ExtendedIsolationForest {
    static IsolationForests.TreeBuilder builder(int extensionLevel) {
        return (X, selection, limit, rnd) -> new Builder(X, limit, extensionLevel, rnd).root(selection);
    }

    @Generated
    private ExtendedIsolationForest() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Builder {
        final Matrix X;
        final double limit;
        final int extensionLevel;
        final Random rnd;

        IsolationForests.Node root(int[] selection) {
            int[] sel = selection;
            if (sel == null) {
                sel = new int[this.X.getColumnsCount()];
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = i;
                }
            }
            return this.node(sel, 0);
        }

        IsolationForests.Node node(int[] items, int level) {
            int size = items.length;
            int dim = this.X.getRowsCount();
            double[] xmin = new double[dim];
            double[] xmax = new double[dim];
            for (int i = 0; i < dim; ++i) {
                double cmin;
                double cmax = cmin = this.X.get(i, items[0]);
                for (int j = 1; j < size; ++j) {
                    double cur = this.X.get(i, items[j]);
                    if (cur < cmin) {
                        cmin = cur;
                        continue;
                    }
                    if (!(cur > cmax)) continue;
                    cmax = cur;
                }
                xmin[i] = cmin;
                xmax[i] = cmax;
            }
            IntList XL = new IntList(size);
            IntList XR = new IntList(size);
            double pdotn = 0.0;
            int o = 0;
            int omax = 3 * dim;
            double[] p = new double[dim];
            double[] n = new double[dim];
            DataBlock N = DataBlock.of(n);
            DataBlock P = DataBlock.of(p);
            do {
                int i;
                int k;
                XL.clear();
                XR.clear();
                N.set(0.0);
                P.set(0.0);
                int n2 = k = this.extensionLevel > 0 && this.extensionLevel < dim ? this.extensionLevel : dim;
                if (k < dim) {
                    int i2;
                    int[] idx = IsolationForests.sampleWithoutReplacement(k, dim, false, this.rnd);
                    for (i2 = 0; i2 < k; ++i2) {
                        n[idx[i2]] = this.rnd.nextGaussian();
                    }
                    for (i2 = 0; i2 < k; ++i2) {
                        double r = this.rnd.nextDouble();
                        int c = idx[i2];
                        p[c] = xmin[c] + r * (xmax[c] - xmin[c]);
                    }
                } else {
                    for (i = 0; i < dim; ++i) {
                        n[i] = this.rnd.nextGaussian();
                    }
                    for (i = 0; i < dim; ++i) {
                        double r = this.rnd.nextDouble();
                        p[i] = xmin[i] + r * (xmax[i] - xmin[i]);
                    }
                }
                pdotn = P.dot(N);
                for (i = 0; i < size; ++i) {
                    double innerprod = N.dot(this.X.column(items[i]));
                    if (innerprod < pdotn) {
                        XL.add(i);
                        continue;
                    }
                    XR.add(i);
                }
            } while (o++ < omax && (XL.isEmpty() || XR.isEmpty()));
            IsolationForests.Node left = (double)level > this.limit || XL.size() <= 1 ? IsolationForests.FinalNode.of(XL.size()) : this.node(XL.toArray(), level + 1);
            IsolationForests.Node right = (double)level > this.limit || XR.size() <= 1 ? IsolationForests.FinalNode.of(XR.size()) : this.node(XR.toArray(), level + 1);
            return new XNode(items, (DoubleSeq)N, pdotn, left, right);
        }

        @Generated
        public Builder(Matrix X, double limit, int extensionLevel, Random rnd) {
            this.X = X;
            this.limit = limit;
            this.extensionLevel = extensionLevel;
            this.rnd = rnd;
        }
    }

    static class XNode
    implements IsolationForests.Node {
        final int[] items;
        final DoubleSeq normalVector;
        final double pdotn;
        final IsolationForests.Node left;
        final IsolationForests.Node right;

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public int size() {
            return this.items.length;
        }

        @Override
        public IsolationForests.Node left() {
            return this.left;
        }

        @Override
        public IsolationForests.Node right() {
            return this.right;
        }

        @Override
        public IsolationForests.Node branch(DoubleSeq x) {
            double innerprod = this.normalVector.dot(x);
            if (innerprod < this.pdotn) {
                return this.left;
            }
            return this.right;
        }

        @Generated
        XNode(int[] items, DoubleSeq normalVector, double pdotn, IsolationForests.Node left, IsolationForests.Node right) {
            this.items = items;
            this.normalVector = normalVector;
            this.pdotn = pdotn;
            this.left = left;
            this.right = right;
        }
    }
}

