/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.splines;

import internal.toolkit.base.core.math.functions.gsl.interpolation.CubicSplines;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import lombok.Generated;

public final class CubicSpline {
    public static DoubleUnaryOperator of(double[] xi, double[] fxi) {
        return new CubicSplineFunction(xi, fxi);
    }

    public static DoubleUnaryOperator monotonic(double[] xi, double[] fxi) {
        return new MonotonicCubicSplineFunction(xi, fxi, MonotonicMethod.FritschCarlson);
    }

    public static DoubleUnaryOperator periodic(double[] x, double[] y) {
        return CubicSplines.periodic(DoubleSeq.of((double[])x), DoubleSeq.of((double[])y));
    }

    @Generated
    private CubicSpline() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class CubicSplineFunction
    implements DoubleUnaryOperator {
        final int n;
        final double[] xi;
        final double[] a;
        final double[] b;
        final double[] c;
        final double[] d;

        CubicSplineFunction(double[] xi, double[] fxi) {
            int i;
            this.xi = (double[])xi.clone();
            this.a = (double[])fxi.clone();
            this.n = xi.length - 1;
            this.b = new double[this.n];
            this.c = new double[this.n + 1];
            this.d = new double[this.n];
            double[] h = new double[this.n];
            for (int i2 = 0; i2 < this.n; ++i2) {
                h[i2] = xi[i2 + 1] - xi[i2];
            }
            double[] m = new double[this.n];
            double[] z = new double[this.n];
            for (i = 1; i < this.n; ++i) {
                double l = 2.0 * (xi[i + 1] - xi[i - 1]) - h[i - 1] * m[i - 1];
                m[i] = h[i] / l;
                double alpha = 3.0 / h[i] * (this.a[i + 1] - this.a[i]) - 3.0 / h[i - 1] * (this.a[i] - this.a[i - 1]);
                z[i] = (alpha - h[i - 1] * z[i - 1]) / l;
            }
            for (i = this.n - 1; i >= 0; --i) {
                this.c[i] = z[i] - m[i] * this.c[i + 1];
                this.b[i] = (this.a[i + 1] - this.a[i]) / h[i] - h[i] * (this.c[i + 1] + 2.0 * this.c[i]) / 3.0;
                this.d[i] = (this.c[i + 1] - this.c[i]) / (3.0 * h[i]);
            }
        }

        private int find(double x) {
            if (x <= this.xi[0]) {
                return -1;
            }
            if (x >= this.xi[this.n]) {
                return this.n;
            }
            int pos = Arrays.binarySearch(this.xi, x);
            if (pos >= 0) {
                return pos;
            }
            return -pos - 2;
        }

        private double compute(double x, int p) {
            double dx = x - this.xi[p];
            double dx2 = dx * dx;
            double dx3 = dx2 * dx;
            return this.a[p] + this.b[p] * dx + this.c[p] * dx2 + this.d[p] * dx3;
        }

        private double compute0(double x) {
            double df = this.b[0];
            return this.a[0] + (x - this.xi[0]) * df;
        }

        private double computen(double x) {
            double dx = this.xi[this.n] - this.xi[this.n - 1];
            double dx2 = dx * dx;
            double df = this.b[this.n - 1] + 2.0 * this.c[this.n - 1] * dx + 3.0 * this.d[this.n - 1] * dx2;
            return this.a[this.n] + (x - this.xi[this.n]) * df;
        }

        @Override
        public double applyAsDouble(double value) {
            int pos = this.find(value);
            if (pos < 0) {
                return this.compute0(value);
            }
            if (pos >= this.n) {
                return this.computen(value);
            }
            return this.compute(value, pos);
        }
    }

    static class MonotonicCubicSplineFunction
    implements DoubleUnaryOperator {
        final int n;
        final double[] xi;
        final double[] a;
        final double[] b;
        final double[] c;
        final double[] d;

        MonotonicCubicSplineFunction(double[] xi, double[] fxi, MonotonicMethod method) {
            int i;
            this.xi = (double[])xi.clone();
            this.a = (double[])fxi.clone();
            this.n = xi.length - 1;
            this.b = new double[this.n + 1];
            this.c = new double[this.n + 1];
            this.d = new double[this.n + 1];
            double[] dy = new double[this.n];
            double[] dx = new double[this.n];
            double[] ms = new double[this.n];
            for (i = 0; i < this.n; ++i) {
                double dxi = xi[i + 1] - xi[i];
                double dyi = this.a[i + 1] - this.a[i];
                dx[i] = dxi;
                dy[i] = dyi;
                ms[i] = dyi / dxi;
            }
            this.b[0] = ms[0];
            for (i = 1; i < this.n; ++i) {
                double m = ms[i - 1];
                double mnext = ms[i];
                if (Math.signum(m) != Math.signum(mnext)) {
                    this.b[i] = 0.0;
                    continue;
                }
                double dxcur = dx[i - 1];
                double dxnext = dx[i];
                double common = dxcur + dxnext;
                this.b[i] = 3.0 * common / ((common + dxnext) / m + (common + dxcur) / mnext);
            }
            this.b[this.n] = ms[this.n - 1];
            for (i = 0; i < this.n; ++i) {
                double c1 = this.b[i];
                double m = ms[i];
                double invdx = 1.0 / dx[i];
                double common = c1 + this.b[i + 1] - 2.0 * m;
                this.c[i] = (m - c1 - common) * invdx;
                this.d[i] = common * invdx * invdx;
            }
        }

        private int find(double x) {
            if (x <= this.xi[0]) {
                return -1;
            }
            if (x >= this.xi[this.n]) {
                return this.n;
            }
            int pos = Arrays.binarySearch(this.xi, x);
            if (pos >= 0) {
                return pos;
            }
            return -pos - 2;
        }

        private double compute(double x, int p) {
            double dx = x - this.xi[p];
            double dx2 = dx * dx;
            double dx3 = dx2 * dx;
            return this.a[p] + this.b[p] * dx + this.c[p] * dx2 + this.d[p] * dx3;
        }

        private double compute0(double x) {
            double df = this.b[0];
            return this.a[0] + (x - this.xi[0]) * df;
        }

        private double computen(double x) {
            double dx = this.xi[this.n] - this.xi[this.n - 1];
            double dx2 = dx * dx;
            double df = this.b[this.n - 1] + 2.0 * this.c[this.n - 1] * dx + 3.0 * this.d[this.n - 1] * dx2;
            return this.a[this.n] + (x - this.xi[this.n]) * df;
        }

        @Override
        public double applyAsDouble(double value) {
            int pos = this.find(value);
            if (pos < 0) {
                return this.compute0(value);
            }
            if (pos >= this.n) {
                return this.computen(value);
            }
            return this.compute(value, pos);
        }
    }

    public static enum MonotonicMethod {
        FritschCarlson,
        Steffen,
        Stineman;

    }
}

