/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials.spi;

import jdplus.toolkit.base.api.advanced.math.Polynomials;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.polynomials.EigenValuesSolver;
import jdplus.toolkit.base.core.math.polynomials.FastEigenValuesSolver;
import jdplus.toolkit.base.core.math.polynomials.MullerNewtonSolver;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RobustMullerNewtonSolver;

public class PolynomialsProcessor
implements Polynomials.Processor {
    public Complex[] rootsOf(DoubleSeq polynomial, Polynomials.Solver solver) {
        return Polynomial.ofInternal(polynomial.toArray()).roots(switch (solver) {
            case Polynomials.Solver.MullerNewton -> new MullerNewtonSolver();
            case Polynomials.Solver.EigenValues -> new EigenValuesSolver();
            case Polynomials.Solver.FastEigenValues -> new FastEigenValuesSolver();
            case Polynomials.Solver.Robust -> new RobustMullerNewtonSolver();
            default -> new MullerNewtonSolver();
        });
    }

    public DoubleSeq zero() {
        return DoubleSeq.of((double[])new double[]{0.0});
    }

    public DoubleSeq plus(DoubleSeq a, DoubleSeq b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DoubleSeq opposite(DoubleSeq x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DoubleSeq minus(DoubleSeq a, DoubleSeq b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DoubleSeq one() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DoubleSeq times(DoubleSeq a, DoubleSeq b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double evaluate(DoubleSeq polynomial, double x) {
        int n = polynomial.length() - 1;
        DoubleSeqCursor cursor = polynomial.reverse().cursor();
        double f = cursor.getAndNext();
        for (int i = n - 1; i >= 0; --i) {
            f = cursor.getAndNext() + f * x;
        }
        return f;
    }

    public Complex evaluate(DoubleSeq polynomial, Complex x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

