/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.PolynomialComputer;

public class NewtonOptimizer {
    private static final int NITERMAX = 30;
    private static final double NFACTOR = 5.0;
    private static final double NFVALUE = 1.0E36;
    private static final int NNOISEMAX = 5;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double NBOUND = 100.0 * Math.sqrt(2.220446049250313E-16);
    private static final double DFBOUND = 1.0E-6;
    final PolynomialComputer fn;
    Complex r;
    private double err;
    private int multiplicity;
    final boolean mroots;

    public NewtonOptimizer(Polynomial p, boolean mroots) {
        this.fn = new PolynomialComputer(p.divide(p.get(p.degree())));
        this.mroots = mroots;
    }

    public Complex root(Complex ns) {
        Complex xcur;
        double fabsmin = 1.0E36;
        double eps = 2.220446049250313E-16;
        int noise = 0;
        int d = this.fn.getPolynomialDegree();
        Complex xmin = xcur = ns;
        Complex dx = Complex.ONE;
        this.err = 1.0;
        for (int i = 0; i < 30; ++i) {
            Complex dxh;
            Polynomial D;
            NewtonOptimizer doptimizer;
            Complex rroot;
            this.fn.computeAll(xcur);
            Complex f = this.fn.f();
            Complex df = this.fn.df();
            if (f.abs() < fabsmin) {
                xmin = xcur;
                fabsmin = f.abs();
                noise = 0;
            }
            double axcur = xcur.abs();
            if (this.mroots && axcur != 0.0 && fabsmin < 1.0E-6 && df.abs() / axcur < 0.001 && d > 1 && (rroot = (doptimizer = new NewtonOptimizer(D = this.fn.D(1), true)).root(xcur)) != null) {
                this.multiplicity = 1 + doptimizer.multiplicity;
                this.err = doptimizer.getError();
                return rroot;
            }
            if (df.abs() > eps && (dxh = f.div(df)).abs() < this.err * 5.0) {
                dx = dxh;
                this.err = dx.abs();
            }
            if (axcur != 0.0 && (this.err / axcur < eps || noise == 5)) {
                xmin = this.checkRealRoot(xmin);
                this.err /= axcur;
                this.multiplicity = 1;
                return xmin;
            }
            xcur = xcur.minus(dx);
            ++noise;
        }
        if (fabsmin > NBOUND) {
            return null;
        }
        double axmin2 = (xmin = this.checkRealRoot(xmin)).abs();
        if (axmin2 != 0.0) {
            this.err /= axmin2;
        }
        this.multiplicity = 1;
        return xmin;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    private Complex checkRealRoot(Complex xmin) {
        double axim = Math.abs(xmin.getIm());
        if (axim < NBOUND) {
            return Complex.cart((double)xmin.getRe(), (double)0.0);
        }
        return xmin;
    }

    public double getError() {
        return this.err;
    }
}

