/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import lombok.Generated;

public final class YPAX {
    public static void apply(DataBlock y, double a, DoubleSeq x) {
        int inc = y.getIncrement();
        int n = y.length();
        if (inc == 1) {
            YPAX.apply(y.getStorage(), y.getStartPosition(), n, a, x);
        } else {
            YPAX.apply(y.getStorage(), y.getStartPosition(), n, inc, a, x);
        }
    }

    public static void apply(DataBlock y, double a, DataBlock x) {
        if (a == 0.0) {
            return;
        }
        if (y.getIncrement() == 1) {
            if (x.getIncrement() == 1) {
                int i = y.getStartPosition();
                int j = x.getStartPosition();
                while (i < y.getEndPosition()) {
                    double[] dArray = y.getStorage();
                    int n = i++;
                    dArray[n] = dArray[n] + a * x.getStorage()[j];
                    ++j;
                }
            } else {
                int i = y.getStartPosition();
                int j = x.getStartPosition();
                while (i < y.getEndPosition()) {
                    double[] dArray = y.getStorage();
                    int n = i++;
                    dArray[n] = dArray[n] + a * x.getStorage()[j];
                    j += x.getIncrement();
                }
            }
        } else if (x.getIncrement() == 1) {
            int i = y.getStartPosition();
            int j = x.getStartPosition();
            while (i != y.getEndPosition()) {
                double[] dArray = y.getStorage();
                int n = i;
                dArray[n] = dArray[n] + a * x.getStorage()[j];
                i += y.getIncrement();
                ++j;
            }
        } else {
            int i = y.getStartPosition();
            int j = x.getStartPosition();
            while (i != y.getEndPosition()) {
                double[] dArray = y.getStorage();
                int n = i;
                dArray[n] = dArray[n] + a * x.getStorage()[j];
                i += y.getIncrement();
                j += x.getIncrement();
            }
        }
    }

    public static void apply(double[] py, int start, int n, double a, DoubleSeq x) {
        if (n == 0 || a == 0.0) {
            return;
        }
        int end = start + n;
        DoubleSeqCursor xcur = x.cursor();
        if (a == 1.0) {
            int i = start;
            while (i < end) {
                int n2 = i++;
                py[n2] = py[n2] + xcur.getAndNext();
            }
        } else if (a == -1.0) {
            for (int i = start; i < end; ++i) {
                py[i] = xcur.getAndNext();
            }
        } else {
            int i = start;
            while (i < end) {
                int n3 = i++;
                py[n3] = py[n3] + a * xcur.getAndNext();
            }
        }
    }

    public static void apply(double[] py, int start, int inc, int n, double a, DoubleSeq x) {
        if (n == 0 || a == 0.0) {
            return;
        }
        int end = start + n * inc;
        DoubleSeqCursor xcur = x.cursor();
        if (a == 1.0) {
            while (start != end) {
                int n2 = start;
                py[n2] = py[n2] + xcur.getAndNext();
                start += inc;
            }
        } else if (a == -1.0) {
            while (start != end) {
                py[start] = xcur.getAndNext();
                start += inc;
            }
        } else {
            while (start != end) {
                int n3 = start;
                py[n3] = py[n3] + a * xcur.getAndNext();
                start += inc;
            }
        }
    }

    public static void apply(double a, double[] px, int xstart, double[] py, int ystart, int n) {
        if (n == 0 || a == 0.0) {
            return;
        }
        int end = ystart + n;
        if (a == 1.0) {
            int i = ystart;
            int j = xstart;
            while (i < end) {
                int n2 = i++;
                py[n2] = py[n2] + px[j];
                ++j;
            }
        } else if (a == -1.0) {
            int i = ystart;
            int j = xstart;
            while (i < end) {
                int n3 = i++;
                py[n3] = py[n3] - px[j];
                ++j;
            }
        } else {
            int i = ystart;
            int j = xstart;
            while (i < end) {
                int n4 = i++;
                py[n4] = py[n4] + a * px[j];
                ++j;
            }
        }
    }

    public static void apply(double a, double[] px, int xstart, int xinc, double[] py, int ystart, int yinc, int n) {
        if (n == 0 || a == 0.0) {
            return;
        }
        int end = ystart + n * yinc;
        if (a == 1.0) {
            while (ystart != end) {
                int n2 = ystart;
                py[n2] = py[n2] + px[xstart];
                ystart += yinc;
                xstart += xinc;
            }
        } else if (a == -1.0) {
            while (ystart != end) {
                int n3 = ystart;
                py[n3] = py[n3] - px[xstart];
                ystart += yinc;
                xstart += xinc;
            }
        } else {
            int i = ystart;
            int j = xstart;
            while (i < end) {
                int n4 = i;
                py[n4] = py[n4] + a * px[j];
                i += yinc;
                j += xinc;
            }
        }
    }

    @Generated
    private YPAX() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

