/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ScaledSumOfSquares {
    private double sumsq = 0.0;
    private double scale = 1.0;

    public double value() {
        return this.sumsq * this.scale * this.scale;
    }

    public double sqrt() {
        return this.scale * Math.sqrt(this.sumsq);
    }

    public void add(double x) {
        double absxi = Math.abs(x);
        if (Double.isNaN(absxi)) {
            this.scale = Double.NaN;
            this.sumsq = Double.NaN;
            return;
        }
        if (absxi > 0.0) {
            if (this.scale < absxi) {
                double tmp = this.scale / absxi;
                this.sumsq = 1.0 + this.sumsq * tmp * tmp;
                this.scale = absxi;
            } else {
                double tmp = absxi / this.scale;
                this.sumsq += tmp * tmp;
            }
        }
    }

    public void add(double[] x, int start, int n, int inc) {
        if (n > 0) {
            int imax = start + n * inc;
            for (int i = start; i < imax; i += inc) {
                double tmp;
                double absxi = Math.abs(x[i]);
                if (Double.isNaN(absxi)) {
                    this.scale = Double.NaN;
                    this.sumsq = Double.NaN;
                    return;
                }
                if (!(absxi > 0.0)) continue;
                if (this.scale < absxi) {
                    tmp = this.scale / absxi;
                    this.sumsq = 1.0 + this.sumsq * tmp * tmp;
                    this.scale = absxi;
                    continue;
                }
                tmp = absxi / this.scale;
                this.sumsq += tmp * tmp;
            }
        }
    }

    @Generated
    public double getSumsq() {
        return this.sumsq;
    }

    @Generated
    public double getScale() {
        return this.scale;
    }

    @Generated
    public void setSumsq(double sumsq) {
        this.sumsq = sumsq;
    }

    @Generated
    public void setScale(double scale) {
        this.scale = scale;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaledSumOfSquares)) {
            return false;
        }
        ScaledSumOfSquares other = (ScaledSumOfSquares)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSumsq(), other.getSumsq()) != 0) {
            return false;
        }
        return Double.compare(this.getScale(), other.getScale()) == 0;
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ScaledSumOfSquares;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sumsq = Double.doubleToLongBits(this.getSumsq());
        result = result * 59 + (int)($sumsq >>> 32 ^ $sumsq);
        long $scale = Double.doubleToLongBits(this.getScale());
        result = result * 59 + (int)($scale >>> 32 ^ $scale);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ScaledSumOfSquares(sumsq=" + this.getSumsq() + ", scale=" + this.getScale() + ")";
    }
}

