/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.CPointer;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

public final class GER {
    public static void apply(double alpha, DataPointer x, DataPointer y, FastMatrix A) {
        if (alpha == 0.0) {
            return;
        }
        int m = A.getRowsCount();
        int n = A.getColumnsCount();
        int lda = A.getColumnIncrement();
        int start = A.getStartPosition();
        int incx = x.inc();
        if (incx == 1) {
            CPointer ca = new CPointer(A.getStorage(), start);
            CPointer cx = (CPointer)x;
            for (int c = 0; c < n; ++c) {
                double z = y.value(c);
                if (z != 0.0) {
                    ca.addAX(m, z * alpha, cx);
                }
                ca.move(lda);
            }
        } else {
            CPointer ca = new CPointer(A.getStorage(), start);
            for (int c = 0; c < n; ++c) {
                double z = y.value(c);
                if (z != 0.0) {
                    ca.addAX(m, z * alpha, x);
                }
                ca.move(lda);
            }
        }
    }

    @Generated
    private GER() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

