/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrixLoader;
import jdplus.toolkit.base.core.math.matrices.decomposition.CroutDoolittle;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;
import jdplus.toolkit.base.core.math.matrices.lapack.SYRK;
import jdplus.toolkit.base.core.random.MersenneTwister;
import lombok.Generated;

public final class SymmetricMatrix {
    private static final SymmetricMatrixLoader.CholeskyProcessor CHOLESKY = new SymmetricMatrixLoader.CholeskyProcessor();

    public static void XtSX() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void randomize(FastMatrix S, RandomNumberGenerator rng) {
        if (!S.isSquare()) {
            throw new MatrixException("m_err_square");
        }
        int n = S.getRowsCount();
        int start = S.getStartPosition();
        int lda = S.getColumnIncrement();
        if (rng == null) {
            rng = MersenneTwister.fromSystemNanoTime();
        }
        double[] x = S.getStorage();
        int max = start + lda * n;
        for (int id = start; id < max; id += lda + 1) {
            x[id] = rng.nextDouble();
            int il = id + 1;
            for (int iu = id + lda; iu < max; iu += lda) {
                double q;
                x[iu] = q = rng.nextDouble();
                x[il] = q;
                ++il;
            }
        }
    }

    public static void lcholesky(FastMatrix L, double zero) {
        CHOLESKY.get().lcholesky(L, zero);
    }

    public static void lcholesky(FastMatrix L) {
        CHOLESKY.get().lcholesky(L, 0.0);
    }

    public static void ucholesky(FastMatrix M, double zero) {
        CHOLESKY.get().ucholesky(M, zero);
    }

    public static void ucholesky(FastMatrix M) {
        CHOLESKY.get().ucholesky(M, 0.0);
    }

    public static void LLt(FastMatrix L, FastMatrix M) {
        int nr = L.getRowsCount();
        int nc = L.getColumnsCount();
        int lcinc = L.getColumnIncrement();
        int mcinc = M.getColumnIncrement();
        double[] pl = L.getStorage();
        double[] pm = M.getStorage();
        int i = 0;
        int ix = L.getStartPosition();
        int im = M.getStartPosition();
        while (i < nr) {
            int j = i;
            int kx = ix;
            int km = im;
            int ks = im;
            while (j < nr) {
                double z = 0.0;
                int max = im + lcinc;
                int jx = ix;
                int lx = kx;
                while (jx != max) {
                    z += pl[jx] * pl[lx];
                    jx += lcinc;
                    lx += lcinc;
                }
                pm[km] = z;
                if (ks != km) {
                    pm[ks] = z;
                }
                ++j;
                ++kx;
                ++km;
                ks += mcinc;
            }
            ++i;
            ++ix;
            im += 1 + mcinc;
        }
    }

    public static void UUt(FastMatrix U, FastMatrix M) {
        int nr = U.getRowsCount();
        int nc = U.getColumnsCount();
        int lcinc = U.getColumnIncrement();
        int mcinc = M.getColumnIncrement();
        double[] pl = U.getStorage();
        double[] pm = M.getStorage();
        int i = 0;
        int ix = U.getStartPosition();
        int imax = ix + nc * lcinc;
        int im = M.getStartPosition();
        while (i < nr) {
            int j = i;
            int kx = ix;
            int ixc = ix;
            int km = im;
            int ks = im;
            while (j < nr) {
                double z = 0.0;
                int jx = ixc;
                int lx = kx;
                while (jx != imax) {
                    z += pl[jx] * pl[lx];
                    jx += lcinc;
                    lx += lcinc;
                }
                pm[km] = z;
                if (ks != km) {
                    pm[ks] = z;
                }
                ++j;
                kx += 1 + lcinc;
                ++km;
                ks += mcinc;
                ixc += lcinc;
            }
            ++i;
            ix += 1 + lcinc;
            im += 1 + mcinc;
            ++imax;
        }
    }

    public static void LtL(FastMatrix L, FastMatrix M) {
        int n = L.getRowsCount();
        double[] pl = L.getStorage();
        double[] pm = M.getStorage();
        int r = 0;
        int mpos = 0;
        int x0 = 0;
        int x1 = n;
        while (r < n) {
            mpos += r;
            int xpos = x0;
            for (int c = r; c < n; ++c) {
                double s = 0.0;
                int xcur = x0 + c;
                int ycur = xpos + c;
                while (xcur < x1) {
                    s += pl[xcur] * pl[ycur];
                    ++xcur;
                    ++ycur;
                }
                pm[mpos++] = s;
                xpos += n;
            }
            ++r;
            x0 += n;
            x1 += n;
        }
        SymmetricMatrix.fromLower(M);
    }

    public static void UtU(FastMatrix U, FastMatrix M) {
        int n = U.getRowsCount();
        double[] pu = U.getStorage();
        double[] pm = M.getStorage();
        int r = 0;
        int mpos = 0;
        int x0 = 0;
        while (r < n) {
            mpos += r;
            int c = r;
            int xpos = x0;
            int x1 = x0 + r;
            while (c < n) {
                double s = 0.0;
                int xcur = x0;
                int ycur = xpos;
                while (xcur <= x1) {
                    s += pu[xcur] * pu[ycur];
                    ++xcur;
                    ++ycur;
                }
                pm[mpos++] = s;
                xpos += n;
                ++c;
                ++x1;
            }
            ++r;
            x0 += n;
        }
        SymmetricMatrix.fromLower(M);
    }

    public static FastMatrix inverse(FastMatrix S) {
        try {
            FastMatrix lower = S.deepClone();
            SymmetricMatrix.lcholesky(lower);
            lower = LowerTriangularMatrix.inverse(lower);
            return SymmetricMatrix.LtL(lower);
        }
        catch (MatrixException e) {
            LUDecomposition lu = CroutDoolittle.decompose(S);
            FastMatrix I = FastMatrix.identity(S.getRowsCount());
            lu.solve(I);
            return I;
        }
    }

    public static void solve(FastMatrix S, DataBlock y, boolean clone) {
        FastMatrix lower = clone ? S.deepClone() : S;
        SymmetricMatrix.lcholesky(lower);
        LowerTriangularMatrix.solveLx(lower, y);
        LowerTriangularMatrix.solvexL(lower, y);
    }

    public static void solveSX(FastMatrix S, FastMatrix B, boolean clone) {
        FastMatrix Q = S;
        if (clone) {
            Q = Q.deepClone();
        }
        SymmetricMatrix.lcholesky(Q);
        LowerTriangularMatrix.solveLX(Q, B);
        LowerTriangularMatrix.solveLtX(Q, B);
    }

    public static void solveXS(FastMatrix S, FastMatrix B, boolean clone) {
        FastMatrix Q = S;
        if (clone) {
            Q = Q.deepClone();
        }
        SymmetricMatrix.lcholesky(Q);
        LowerTriangularMatrix.solveXLt(Q, B);
        LowerTriangularMatrix.solveXL(Q, B);
    }

    public static FastMatrix XXt(FastMatrix X) {
        int nr = X.getRowsCount();
        FastMatrix S = FastMatrix.square(nr);
        double[] sx = S.getStorage();
        double[] px = X.getStorage();
        int xmax = px.length;
        int x0 = 0;
        while (x0 < xmax) {
            int x1 = x0 + nr;
            int pos = 0;
            int ypos = x0;
            for (int c = 0; c < nr; ++c) {
                double yc = px[ypos];
                if (yc != 0.0) {
                    pos += c;
                    for (int xpos = x0; xpos < x1; ++xpos) {
                        int n = pos++;
                        sx[n] = sx[n] + yc * px[xpos];
                    }
                } else {
                    pos += nr;
                }
                ++ypos;
                ++x0;
            }
        }
        SymmetricMatrix.fromLower(S);
        return S;
    }

    public static FastMatrix XtX(FastMatrix X) {
        int nr = X.getRowsCount();
        int nc = X.getColumnsCount();
        FastMatrix M = FastMatrix.square(nc);
        double[] px = X.getStorage();
        double[] pm = M.getStorage();
        int xstart = X.getStartPosition();
        int xinc = X.getColumnIncrement();
        int xmax = xstart + xinc * nc;
        int c = 0;
        int mpos = 0;
        int x0 = xstart;
        int x1 = xstart + nr;
        while (c < nc) {
            mpos += c;
            for (int xpos = x0; xpos < xmax; xpos += xinc) {
                double s = 0.0;
                int xcur = x0;
                int ycur = xpos;
                while (xcur < x1) {
                    s += px[xcur] * px[ycur];
                    ++xcur;
                    ++ycur;
                }
                pm[mpos++] = s;
            }
            ++c;
            x0 += xinc;
            x1 += xinc;
        }
        SymmetricMatrix.fromLower(M);
        return M;
    }

    public static FastMatrix UUt(FastMatrix U) {
        FastMatrix M = FastMatrix.square(U.getColumnsCount());
        SymmetricMatrix.UUt(U, M);
        return M;
    }

    public static FastMatrix LLt(FastMatrix L) {
        FastMatrix M = FastMatrix.square(L.getRowsCount());
        SymmetricMatrix.LLt(L, M);
        return M;
    }

    public static FastMatrix UtU(FastMatrix U) {
        FastMatrix M = FastMatrix.square(U.getColumnsCount());
        SymmetricMatrix.UtU(U, M);
        return M;
    }

    public static FastMatrix LtL(FastMatrix L) {
        FastMatrix M = FastMatrix.square(L.getColumnsCount());
        SymmetricMatrix.LtL(L, M);
        return M;
    }

    public static FastMatrix XSXt(FastMatrix S, FastMatrix X) {
        FastMatrix XSX = FastMatrix.square(X.getRowsCount());
        SymmetricMatrix.XSXt(S, X, XSX);
        return XSX;
    }

    public static void XSXt(FastMatrix S, FastMatrix X, FastMatrix M) {
        FastMatrix XS = GeneralMatrix.AB(X, S);
        DataBlockIterator xsrows = XS.rowsIterator();
        DataBlockIterator xtcols = X.rowsIterator();
        DataBlockIterator mcols = M.columnsIterator();
        int c = 0;
        while (xtcols.hasNext()) {
            DataBlock mcol = mcols.next();
            DataBlock col = xtcols.next();
            DoubleSeqCursor.OnMutable mcursor = mcol.cursor();
            mcursor.moveTo(c);
            xsrows.reset(c++);
            while (xsrows.hasNext()) {
                mcursor.setAndNext(xsrows.next().dot(col));
            }
        }
        SymmetricMatrix.fromLower(M);
    }

    public static FastMatrix XtSX(FastMatrix S, FastMatrix X) {
        int n = X.getColumnsCount();
        FastMatrix M = FastMatrix.square(n);
        SymmetricMatrix.XtSX(S, X, M);
        return M;
    }

    public static void XtSX(FastMatrix S, FastMatrix X, FastMatrix M) {
        FastMatrix SX = GeneralMatrix.AB(S, X);
        DataBlockIterator sxcols = SX.columnsIterator();
        DataBlockIterator xtrows = X.columnsIterator();
        DataBlockIterator mcols = M.columnsIterator();
        int c = 0;
        while (sxcols.hasNext()) {
            DataBlock mcol = mcols.next();
            DataBlock col = sxcols.next();
            DoubleSeqCursor.OnMutable mcursor = mcol.cursor();
            mcursor.moveTo(c);
            xtrows.reset(c++);
            while (xtrows.hasNext()) {
                mcursor.setAndNext(xtrows.next().dot(col));
            }
        }
        SymmetricMatrix.fromLower(M);
    }

    public static void reenforceSymmetry(FastMatrix S) {
        if (!S.isSquare()) {
            throw new MatrixException("m_err_square");
        }
        int n = S.getRowsCount();
        int lda = S.getColumnIncrement();
        int start = S.start;
        if (n == 1) {
            return;
        }
        double[] x = S.getStorage();
        int del = lda + 1;
        int max = start + lda * n;
        for (int id = start; id < max; id += del) {
            int il = id + 1;
            for (int iu = id + lda; iu < max; iu += lda) {
                double q;
                x[il] = q = (x[iu] + x[il]) / 2.0;
                x[iu] = q;
                ++il;
            }
        }
    }

    public static LogSign logDeterminant(FastMatrix S) {
        FastMatrix s = S.deepClone();
        SymmetricMatrix.lcholesky(s);
        DataBlock diagonal = s.diagonal();
        LogSign ls = LogSign.of((DoubleSeq)diagonal);
        return new LogSign(ls.getValue() * 2.0, true);
    }

    public static double determinant(FastMatrix L) {
        LogSign ls = SymmetricMatrix.logDeterminant(L);
        if (ls == null) {
            return 0.0;
        }
        return Math.exp(ls.getValue());
    }

    public static void fromLower(FastMatrix S) {
        if (!S.isSquare()) {
            throw new MatrixException("m_err_square");
        }
        int n = S.getRowsCount();
        int lda = S.getColumnIncrement();
        int start = S.start;
        if (n == 1) {
            return;
        }
        double[] x = S.getStorage();
        int del = lda + 1;
        int max = start + lda * n;
        for (int id = start; id < max; id += del) {
            int il = id + 1;
            for (int iu = id + lda; iu < max; iu += lda) {
                x[iu] = x[il];
                ++il;
            }
        }
    }

    public static void fromUpper(FastMatrix S) {
        if (!S.isSquare()) {
            throw new MatrixException("m_err_square");
        }
        int n = S.getRowsCount();
        int lda = S.getColumnIncrement();
        int start = S.start;
        if (n == 1) {
            return;
        }
        double[] x = S.getStorage();
        int del = lda + 1;
        int max = start + lda * n;
        for (int id = start; id < max; id += del) {
            int il = id + 1;
            for (int iu = id + lda; iu < max; iu += lda) {
                x[il] = x[iu];
                ++il;
            }
        }
    }

    private static void lcholesky_1(FastMatrix M, double zero) {
        double[] data = M.getStorage();
        int n = M.getRowsCount();
        int cinc = M.getColumnIncrement();
        int dinc = 1 + cinc;
        int start = M.getStartPosition();
        int end = start + n * dinc;
        int idiag = start;
        int irow = start;
        int cend = start + n;
        while (idiag != end) {
            double aii = data[idiag];
            for (int j = irow; j != idiag; j += cinc) {
                double x = data[j];
                aii -= x * x;
            }
            if (aii < -zero) {
                throw new MatrixException("m_err_chol");
            }
            if (aii <= zero) {
                data[idiag] = 0.0;
                for (jx = irow; jx != idiag; jx += cinc) {
                    temp = data[jx];
                    if (temp == 0.0) continue;
                    ia = jx + 1;
                    iy = idiag + 1;
                    while (iy < cend) {
                        int n2 = iy++;
                        data[n2] = data[n2] - temp * data[ia];
                        ++ia;
                    }
                }
                for (iy = idiag + 1; iy < cend; ++iy) {
                    if (Math.abs(data[iy]) > zero) {
                        throw new MatrixException("m_err_chol");
                    }
                    data[iy] = 0.0;
                }
            } else {
                data[idiag] = aii = Math.sqrt(aii);
                for (jx = irow; jx != idiag; jx += cinc) {
                    temp = data[jx];
                    if (temp == 0.0) continue;
                    ia = jx + 1;
                    iy = idiag + 1;
                    while (iy < cend) {
                        int n3 = iy++;
                        data[n3] = data[n3] - temp * data[ia];
                        ++ia;
                    }
                }
                iy = idiag + 1;
                while (iy < cend) {
                    int n4 = iy++;
                    data[n4] = data[n4] / aii;
                }
            }
            ++irow;
            idiag += dinc;
            cend += cinc;
        }
        LowerTriangularMatrix.toLower(M);
    }

    public static void xxt(DataBlock x, FastMatrix M) {
        int nr = x.length();
        int xinc = x.getIncrement();
        int mcinc = M.getColumnIncrement();
        double[] px = x.getStorage();
        double[] pm = M.getStorage();
        if (xinc == 1) {
            int i = 0;
            int ix = x.getStartPosition();
            int im = M.getStartPosition();
            while (i < nr) {
                int j = i;
                int kx = ix;
                int km = im;
                int ks = im;
                while (j < nr) {
                    double z;
                    pm[km] = z = px[ix] * px[kx];
                    if (ks != km) {
                        pm[ks] = z;
                    }
                    ++j;
                    ++kx;
                    ++km;
                    ks += mcinc;
                }
                ++i;
                ++ix;
                im += 1 + mcinc;
            }
        } else {
            int i = 0;
            int ix = x.getStartPosition();
            int im = M.getStartPosition();
            while (i < nr) {
                int j = i;
                int kx = ix;
                int km = im;
                int ks = im;
                while (j < nr) {
                    double z;
                    pm[km] = z = px[ix] * px[kx];
                    if (ks != km) {
                        pm[ks] = z;
                    }
                    ++j;
                    kx += xinc;
                    ++km;
                    ks += mcinc;
                }
                ++i;
                ix += xinc;
                im += 1 + mcinc;
            }
        }
    }

    public static void XXt(FastMatrix X, FastMatrix M) {
        int nr = X.getRowsCount();
        int nc = X.getColumnsCount();
        int xcinc = X.getColumnIncrement();
        int mcinc = M.getColumnIncrement();
        double[] px = X.getStorage();
        double[] pm = M.getStorage();
        if (xcinc != 1) {
            int i = 0;
            int ix = X.getStartPosition();
            int im = M.getStartPosition();
            while (i < nr) {
                int j = i;
                int kx = ix;
                int km = im;
                int ks = im;
                while (j < nr) {
                    double z = 0.0;
                    int c = 0;
                    int jx = ix;
                    int lx = kx;
                    while (c < nc) {
                        z += px[jx] * px[lx];
                        ++c;
                        jx += xcinc;
                        lx += xcinc;
                    }
                    pm[km] = z;
                    if (ks != km) {
                        pm[ks] = z;
                    }
                    ++j;
                    ++kx;
                    ++km;
                    ks += mcinc;
                }
                ++i;
                ++ix;
                im += 1 + mcinc;
            }
        } else {
            int i = 0;
            int ix = X.getStartPosition();
            int im = M.getStartPosition();
            while (i < nr) {
                int j = i;
                int kx = ix;
                int km = im;
                int ks = im;
                while (j < nr) {
                    double z = 0.0;
                    int c = 0;
                    int jx = ix;
                    int lx = kx;
                    while (c < nc) {
                        z += px[jx] * px[lx];
                        ++c;
                        ++jx;
                        ++lx;
                    }
                    pm[km] = z;
                    if (ks != km) {
                        pm[ks] = z;
                    }
                    ++j;
                    ++kx;
                    ++km;
                    ks += mcinc;
                }
                ++i;
                ++ix;
                im += 1 + mcinc;
            }
        }
    }

    public static FastMatrix xxt(DataBlock x) {
        FastMatrix M = FastMatrix.square(x.length());
        SymmetricMatrix.xxt(x, M);
        return M;
    }

    public static void XtX(FastMatrix X, FastMatrix M) {
        SYRK.lapply(false, 1.0, X, 0.0, M);
        SymmetricMatrix.fromLower(M);
    }

    @Generated
    private SymmetricMatrix() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface CholeskyProcessor {
        public void lcholesky(FastMatrix var1, double var2);

        public void ucholesky(FastMatrix var1, double var2);

        default public void lcholesky(FastMatrix L) {
            this.lcholesky(L, 0.0);
        }

        default public void ucholesky(FastMatrix U) {
            this.ucholesky(U, 0.0);
        }
    }
}

