/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.random.MersenneTwister;
import lombok.Generated;

public final class MatrixUtility {
    public static void randomize(FastMatrix M, RandomNumberGenerator rng) {
        if (M.isEmpty()) {
            return;
        }
        if (rng == null) {
            rng = MersenneTwister.fromSystemNanoTime();
        }
        double[] x = M.getStorage();
        if (M.isFull()) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = rng.nextDouble();
            }
            return;
        }
        int m = M.getRowsCount();
        int n = M.getColumnsCount();
        int start = M.getStartPosition();
        int lda = M.getColumnIncrement();
        int jmax = start + n * lda;
        for (int j = start; j < jmax; j += lda) {
            int imax = j + n;
            for (int i = j; i < imax; ++i) {
                x[i] = rng.nextDouble();
            }
        }
    }

    @Generated
    private MatrixUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

