/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import java.util.function.DoublePredicate;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public final class CPointer
extends DataPointer {
    public CPointer(double[] storage, int pos) {
        super(storage, pos);
    }

    @Override
    public int inc() {
        return 1;
    }

    @Override
    public double value(int n) {
        return this.p[this.pos + n];
    }

    @Override
    public double dot(int n, DataPointer x) {
        int imax = this.pos + n;
        int xinc = x.inc();
        double s = 0.0;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            s += this.p[i] * x.p[j];
            ++i;
            j += xinc;
        }
        return s;
    }

    @Override
    public void addAX(int n, double a, DataPointer x) {
        int imax = this.pos + n;
        int xinc = x.inc();
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] + a * x.p[j];
            j += xinc;
        }
    }

    public void addAX(int n, double a, CPointer x) {
        int imax = this.pos + n;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] + a * x.p[j];
            ++j;
        }
    }

    @Override
    public boolean test(int n, DoublePredicate pred) {
        int imax = this.pos + n;
        for (int i = this.pos; i < imax; ++i) {
            if (pred.test(this.p[i])) continue;
            return false;
        }
        return true;
    }

    public double dot(int n, CPointer x) {
        int imax = this.pos + n;
        double s = 0.0;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            s += this.p[i] * x.p[j];
            ++i;
            ++j;
        }
        return s;
    }

    public void add(int n, CPointer x) {
        int imax = this.pos + n;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] + x.p[j];
            ++j;
        }
    }

    public void sub(int n, CPointer x) {
        int imax = this.pos + n;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] - x.p[j];
            ++j;
        }
    }

    public void copy(int n, CPointer x) {
        int imax = this.pos + n;
        int i = this.pos;
        int j = x.pos;
        while (i < imax) {
            this.p[i] = x.p[j];
            ++i;
            ++j;
        }
    }

    @Override
    public void mul(int n, double a) {
        int imax = this.pos + n;
        int i = this.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] * a;
        }
    }

    @Override
    public void div(int n, double a) {
        int imax = this.pos + n;
        int i = this.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] / a;
        }
    }

    @Override
    public void add(int n, double a) {
        int imax = this.pos + n;
        int i = this.pos;
        while (i < imax) {
            int n2 = i++;
            this.p[n2] = this.p[n2] + a;
        }
    }

    @Override
    public void set(int n, double a) {
        int imax = this.pos + n;
        for (int i = this.pos; i < imax; ++i) {
            this.p[i] = a;
        }
    }

    @Override
    public void chs(int n) {
        int imax = this.pos + n;
        for (int i = this.pos; i < imax; ++i) {
            this.p[i] = -this.p[i];
        }
    }

    public void swap(int n, CPointer other) {
        int imax = this.pos + n;
        int i = this.pos;
        int j = other.pos;
        while (i < imax) {
            double tmp = this.p[i];
            this.p[i] = other.p[j];
            this.p[j] = tmp;
            ++i;
            ++j;
        }
    }

    @Override
    public double asum(int n) {
        double rslt = 0.0;
        int jmax = this.pos + n;
        for (int j = this.pos; j < jmax; ++j) {
            rslt += Math.abs(this.p[j]);
        }
        return rslt;
    }

    @Override
    public double sum(int n) {
        double rslt = 0.0;
        int jmax = this.pos + n;
        for (int j = this.pos; j < jmax; ++j) {
            rslt += this.p[j];
        }
        return rslt;
    }

    @Override
    public double ssq(int n) {
        double d = 0.0;
        int imax = this.pos + n;
        for (int i = this.pos; i < imax; ++i) {
            double cur = this.p[i];
            d += cur * cur;
        }
        return d;
    }

    public double fastNorm(int n) {
        return Math.sqrt(this.ssq(n));
    }

    @Generated
    public @NonNull String toString() {
        return "CPointer()";
    }
}

