/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearsystem;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class QRLeastSquaresSolution {
    private final QRDecomposition qr;
    private final int rank;
    private final DoubleSeq b;
    private final DoubleSeq e;
    private final double ssqErr;

    public int rank() {
        return this.rank;
    }

    public FastMatrix rawR() {
        return this.qr.rawR();
    }

    public DoubleSeq rawRDiagonal() {
        return this.qr.rawRdiagonal();
    }

    public int[] pivot() {
        return this.qr.pivot();
    }

    public FastMatrix unscaledCovariance() {
        int[] pivot = this.qr.pivot();
        FastMatrix rawR = this.qr.rawR().extract(0, this.rank, 0, this.rank);
        FastMatrix v = SymmetricMatrix.UUt(UpperTriangularMatrix.inverse(rawR));
        int n = this.qr.n();
        if (pivot == null) {
            if (this.rank == n) {
                return v;
            }
            FastMatrix V = FastMatrix.square(n);
            V.extract(0, this.rank, 0, this.rank).copy(v);
            return V;
        }
        FastMatrix V = FastMatrix.square(n);
        for (int i = 0; i < this.rank; ++i) {
            double sii = v.get(i, i);
            V.set(pivot[i], pivot[i], sii);
            for (int j = 0; j < i; ++j) {
                double sij = v.get(i, j);
                V.set(pivot[i], pivot[j], sij);
                V.set(pivot[j], pivot[i], sij);
            }
        }
        return V;
    }

    public FastMatrix RtR() {
        int[] pivot = this.qr.pivot();
        FastMatrix rawR = this.qr.rawR();
        FastMatrix v = SymmetricMatrix.UtU(rawR);
        if (pivot == null) {
            return v;
        }
        int n = pivot.length;
        FastMatrix V = FastMatrix.square(n);
        for (int i = 0; i < this.rank; ++i) {
            double sii = v.get(i, i);
            V.set(pivot[i], pivot[i], sii);
            for (int j = 0; j < i; ++j) {
                double sij = v.get(i, j);
                V.set(pivot[i], pivot[j], sij);
                V.set(pivot[j], pivot[i], sij);
            }
        }
        return V;
    }

    @Generated
    public QRLeastSquaresSolution(QRDecomposition qr, int rank, DoubleSeq b, DoubleSeq e, double ssqErr) {
        this.qr = qr;
        this.rank = rank;
        this.b = b;
        this.e = e;
        this.ssqErr = ssqErr;
    }

    @Generated
    public int getRank() {
        return this.rank;
    }

    @Generated
    public DoubleSeq getB() {
        return this.b;
    }

    @Generated
    public DoubleSeq getE() {
        return this.e;
    }

    @Generated
    public double getSsqErr() {
        return this.ssqErr;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QRLeastSquaresSolution)) {
            return false;
        }
        QRLeastSquaresSolution other = (QRLeastSquaresSolution)o;
        if (this.getRank() != other.getRank()) {
            return false;
        }
        if (Double.compare(this.getSsqErr(), other.getSsqErr()) != 0) {
            return false;
        }
        QRDecomposition this$qr = this.getQr();
        QRDecomposition other$qr = other.getQr();
        if (this$qr == null ? other$qr != null : !this$qr.equals(other$qr)) {
            return false;
        }
        DoubleSeq this$b = this.getB();
        DoubleSeq other$b = other.getB();
        if (this$b == null ? other$b != null : !this$b.equals(other$b)) {
            return false;
        }
        DoubleSeq this$e = this.getE();
        DoubleSeq other$e = other.getE();
        return !(this$e == null ? other$e != null : !this$e.equals(other$e));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRank();
        long $ssqErr = Double.doubleToLongBits(this.getSsqErr());
        result = result * 59 + (int)($ssqErr >>> 32 ^ $ssqErr);
        QRDecomposition $qr = this.getQr();
        result = result * 59 + ($qr == null ? 43 : $qr.hashCode());
        DoubleSeq $b = this.getB();
        result = result * 59 + ($b == null ? 43 : $b.hashCode());
        DoubleSeq $e = this.getE();
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "QRLeastSquaresSolution(qr=" + String.valueOf(this.getQr()) + ", rank=" + this.getRank() + ", b=" + String.valueOf(this.getB()) + ", e=" + String.valueOf(this.getE()) + ", ssqErr=" + this.getSsqErr() + ")";
    }

    @Generated
    private QRDecomposition getQr() {
        return this.qr;
    }
}

