/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class FiniteFilter
implements IFiniteFilter,
Cloneable {
    private final int lb;
    private final double[] w;
    private static final double EPS = 1.0E-4;

    public static FiniteFilter add(IFiniteFilter l, double d) {
        int llb = l.getLowerBound();
        int lub = l.getUpperBound();
        int lb = llb < 0 ? llb : 0;
        int ub = lub < 0 ? 0 : lub;
        double[] p = new double[ub - lb + 1];
        IntToDoubleFunction weights = l.weights();
        for (int i = llb; i <= lub; ++i) {
            p[i - lb] = weights.applyAsDouble(i);
        }
        int n = -lb;
        p[n] = p[n] + d;
        return FiniteFilter.ofInternal(p, lb);
    }

    public static FiniteFilter add(IFiniteFilter l, IFiniteFilter r) {
        int i;
        int llb = l.getLowerBound();
        int lub = l.getUpperBound();
        int rlb = r.getLowerBound();
        int rub = r.getUpperBound();
        int lb = llb < rlb ? llb : rlb;
        int ub = lub < rub ? rub : lub;
        double[] p = new double[ub - lb + 1];
        IntToDoubleFunction lweights = l.weights();
        IntToDoubleFunction rweights = r.weights();
        for (i = llb; i <= lub; ++i) {
            p[i - lb] = lweights.applyAsDouble(i);
        }
        for (i = rlb; i <= rub; ++i) {
            int n = i - lb;
            p[n] = p[n] + rweights.applyAsDouble(i);
        }
        return FiniteFilter.ofInternal(p, lb);
    }

    public static FiniteFilter multiply(IFiniteFilter l, double d) {
        int lb = l.getLowerBound();
        double[] p = l.weightsToArray();
        int i = 0;
        while (i < p.length) {
            int n = i++;
            p[n] = p[n] * d;
        }
        return FiniteFilter.ofInternal(p, lb);
    }

    public static FiniteFilter multiply(IFiniteFilter l, IFiniteFilter r) {
        int llb = l.getLowerBound();
        int rlb = r.getLowerBound();
        Polynomial lp = Polynomial.ofInternal(l.weightsToArray());
        Polynomial rp = Polynomial.ofInternal(r.weightsToArray());
        Polynomial w = lp.times(rp);
        return new FiniteFilter(w, llb + rlb);
    }

    public static FiniteFilter negate(IFiniteFilter l) {
        int lb = l.getLowerBound();
        double[] p = l.weightsToArray();
        for (int i = 0; i < p.length; ++i) {
            p[i] = -p[i];
        }
        return FiniteFilter.ofInternal(p, lb);
    }

    public static FiniteFilter ofInternal(double[] c, int lb) {
        return new FiniteFilter(c, lb);
    }

    public static FiniteFilter of(double[] c, int lb) {
        return new FiniteFilter((double[])c.clone(), lb);
    }

    public static FiniteFilter subtract(IFiniteFilter l, double d) {
        return FiniteFilter.add(l, -d);
    }

    public static FiniteFilter subtract(IFiniteFilter l, IFiniteFilter r) {
        int i;
        int llb = l.getLowerBound();
        int lub = l.getUpperBound();
        int rlb = r.getLowerBound();
        int rub = r.getUpperBound();
        int lb = llb < rlb ? llb : rlb;
        int ub = lub < rub ? rub : lub;
        double[] p = new double[ub - lb + 1];
        IntToDoubleFunction lweights = l.weights();
        IntToDoubleFunction rweights = r.weights();
        for (i = llb; i <= lub; ++i) {
            p[i - lb] = lweights.applyAsDouble(i);
        }
        for (i = rlb; i <= rub; ++i) {
            int n = i - lb;
            p[n] = p[n] - rweights.applyAsDouble(i);
        }
        return FiniteFilter.ofInternal(p, lb);
    }

    private FiniteFilter(double[] c, int lb) {
        this.lb = lb;
        this.w = c;
    }

    public FiniteFilter(Polynomial c, int lb) {
        this.lb = lb;
        this.w = c.toArray();
    }

    public FiniteFilter(IFiniteFilter f) {
        this.w = f.weightsToArray();
        this.lb = f.getLowerBound();
    }

    @Override
    public int length() {
        return this.w.length;
    }

    @Override
    public int getLowerBound() {
        return this.lb;
    }

    @Override
    public int getUpperBound() {
        return this.lb + this.w.length - 1;
    }

    @Override
    public IntToDoubleFunction weights() {
        return i -> this.w[i - this.lb];
    }

    public boolean isSymmetric() {
        int d = this.w.length - 1;
        if (d % 2 != 0 || d != -this.lb) {
            return false;
        }
        for (int i = 0; i < d / 2; ++i) {
            if (!(Math.abs(this.w[i] - this.w[d - i]) > 1.0E-4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FiniteFilter mirror() {
        double[] mw = (double[])this.w.clone();
        Arrays2.reverse((double[])mw);
        int mlb = -this.lb - this.w.length + 1;
        return new FiniteFilter(mw, mlb);
    }

    public String toString() {
        Polynomial p = Polynomial.ofInternal(this.w).smooth();
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
        format.setMaximumFractionDigits(4);
        format.setMinimumFractionDigits(4);
        StringBuilder buffer = new StringBuilder(512);
        int curp = this.lb;
        int n = p.degree();
        int i = 0;
        while (i <= n) {
            double v = Math.abs(p.get(i));
            if (v >= 1.0E-6) {
                if (v > p.get(i)) {
                    buffer.append(" - ");
                } else if (i > 0) {
                    buffer.append(" + ");
                }
                if (v != 1.0 || curp == 0) {
                    buffer.append(format.format(v));
                }
                if (curp < 0) {
                    buffer.append(' ').append('B');
                    if (curp < -1) {
                        buffer.append('^').append(-curp);
                    }
                } else if (curp > 0) {
                    buffer.append(' ').append('F');
                    if (curp > 1) {
                        buffer.append('^').append(curp);
                    }
                }
            }
            ++i;
            ++curp;
        }
        return buffer.toString();
    }
}

