/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.Simplifying;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.ForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;

public final class BackFilter
implements IFiniteFilter {
    public static final BackFilter ZERO = new BackFilter(Polynomial.ZERO);
    public static final BackFilter ONE = new BackFilter(Polynomial.ONE);
    public static final BackFilter D1 = new BackFilter(UnitRoots.D1);
    private final Polynomial polynomial;

    public static BackFilter add(double d, BackFilter l) {
        Polynomial p = l.polynomial.plus(d);
        return new BackFilter(p);
    }

    public static BackFilter multiply(double d, BackFilter l) {
        Polynomial p = l.polynomial.times(d);
        return new BackFilter(p);
    }

    public static BackFilter ofInternal(double ... coefficients) {
        if (coefficients.length == 1) {
            if (coefficients[0] == 1.0) {
                return ONE;
            }
            if (coefficients[0] == 0.0) {
                return ZERO;
            }
        }
        return new BackFilter(Polynomial.ofInternal(coefficients));
    }

    public BackFilter(Polynomial p) {
        this.polynomial = p;
    }

    public DoubleSeq coefficients() {
        return this.polynomial.coefficients();
    }

    public BackFilter divide(BackFilter r) {
        Polynomial.Division div = Polynomial.divide(this.polynomial, r.polynomial);
        return new BackFilter(div.getQuotient());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackFilter other = (BackFilter)obj;
        return this.polynomial.equals(other.polynomial);
    }

    public double get(int idx) {
        return this.polynomial.get(idx);
    }

    public Polynomial asPolynomial() {
        return this.polynomial;
    }

    @Override
    public int length() {
        return this.polynomial.degree() + 1;
    }

    @Override
    public int getLowerBound() {
        return -this.polynomial.degree();
    }

    @Override
    public Complex frequencyResponse(double freq) {
        return FilterUtility.frequencyResponse(i -> this.polynomial.get(i), 0, this.polynomial.degree(), -freq);
    }

    @Override
    public int getUpperBound() {
        return 0;
    }

    public int getDegree() {
        return this.polynomial.degree();
    }

    @Override
    public IntToDoubleFunction weights() {
        return i -> this.polynomial.get(-i);
    }

    public int hashCode() {
        return this.polynomial.hashCode();
    }

    public boolean isIdentity() {
        return this.polynomial.isIdentity();
    }

    public boolean isNull() {
        return this.polynomial.isZero();
    }

    public BackFilter minus(BackFilter r) {
        Polynomial p = this.polynomial.minus(r.polynomial);
        return new BackFilter(p);
    }

    public BackFilter minus(double d) {
        Polynomial p = this.polynomial.minus(d);
        return new BackFilter(p);
    }

    @Override
    public ForeFilter mirror() {
        return new ForeFilter(this.polynomial);
    }

    public BackFilter negate() {
        Polynomial p = this.polynomial.negate();
        return new BackFilter(p);
    }

    public BackFilter normalize() {
        double r = this.polynomial.get(0);
        if (r == 0.0 || r == 1.0) {
            return this;
        }
        return new BackFilter(this.polynomial.times(1.0 / r));
    }

    public BackFilter plus(BackFilter r) {
        Polynomial p = this.polynomial.plus(r.polynomial);
        return new BackFilter(p);
    }

    public BackFilter plus(double d) {
        Polynomial p = this.polynomial.plus(d);
        return new BackFilter(p);
    }

    public Complex[] roots() {
        return this.polynomial.roots();
    }

    public Complex[] roots(RootsSolver solver) {
        return this.polynomial.roots(solver);
    }

    public BackFilter times(BackFilter r) {
        Polynomial p = this.polynomial.times(r.polynomial);
        return new BackFilter(p);
    }

    public BackFilter times(double d) {
        Polynomial p = this.polynomial.times(d);
        return new BackFilter(p);
    }

    public String toString() {
        return this.polynomial.toString('B', true);
    }

    public static class StationaryTransformation {
        public BackFilter unitRoots;
        public BackFilter stationaryFilter;
        private final int freq;

        public StationaryTransformation() {
            this.freq = 0;
        }

        public StationaryTransformation(int freq) {
            this.freq = freq;
        }

        public boolean transform(BackFilter f) {
            UnitRootsSolver urs = this.freq == 0 ? new UnitRootsSolver() : new UnitRootsSolver(this.freq);
            urs.factorize(f.polynomial);
            this.unitRoots = new BackFilter(urs.getUnitRoots().asPolynomial());
            if (this.unitRoots.getDegree() == 0) {
                this.stationaryFilter = f;
                return false;
            }
            this.stationaryFilter = new BackFilter(urs.remainder());
            return true;
        }
    }

    public static class SimplifyingTool
    extends Simplifying<BackFilter> {
        @Override
        public boolean simplify(BackFilter left, BackFilter right) {
            this.clear();
            if (left.getDegree() == 0 || right.getDegree() == 0) {
                return false;
            }
            Polynomial lp = left.polynomial;
            Polynomial rp = right.polynomial;
            double l0 = lp.get(0);
            double r0 = rp.get(0);
            Polynomial.SimplifyingTool psimp = new Polynomial.SimplifyingTool();
            if (psimp.simplify(lp, rp)) {
                lp = (Polynomial)psimp.getLeft();
                rp = (Polynomial)psimp.getRight();
                lp = lp.times(l0 / lp.get(0));
                rp = rp.times(r0 / rp.get(0));
                Polynomial p = (Polynomial)psimp.getCommon();
                p = p.divide(p.get(0));
                this.common = new BackFilter(p);
                this.simplifiedLeft = new BackFilter(lp);
                this.simplifiedRight = new BackFilter(rp);
                return true;
            }
            return false;
        }
    }
}

