/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.highprecision.DoubleComplex;
import jdplus.toolkit.base.core.math.highprecision.DoubleDouble;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleComputer;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleType;
import jdplus.toolkit.base.core.math.highprecision.DoublePolynomial;

public class DoublePolynomialComputer {
    private final double[] p;
    private DoubleComplex f;
    private DoubleComplex df;

    public DoublePolynomialComputer(DoublePolynomial x) {
        this.p = x.storage();
    }

    public int getPolynomialDegree() {
        return (this.p.length >> 1) - 1;
    }

    public DoublePolynomialComputer compute(DoubleComplex x) {
        DoubleDouble xr = x.getRe();
        DoubleDouble xi = x.getIm();
        if (Math.abs(xi.asDouble()) < Constants.getEpsilon()) {
            return this.compute(xr);
        }
        this.df = null;
        int n = this.p.length - 2;
        DoubleDoubleComputer re = new DoubleDoubleComputer(this.p[n], this.p[n + 1]);
        DoubleDoubleComputer im = new DoubleDoubleComputer();
        for (int i = n - 2; i >= 0; i -= 2) {
            double reHigh = re.getHigh();
            double reLow = re.getLow();
            re = re.mul(xr).subXY(xi, im).add(this.p[i], this.p[i + 1]);
            im = im.mul(xr).addXY(reHigh, reLow, xi.getHigh(), xi.getLow());
        }
        this.f = DoubleComplex.cart(re, im);
        return this;
    }

    public DoublePolynomialComputer computeAll(DoubleComplex x) {
        DoubleDouble xr = x.getRe();
        DoubleDouble xi = x.getIm();
        if (Math.abs(xi.asDouble()) < Constants.getEpsilon()) {
            return this.computeAll(xr);
        }
        int n = this.p.length - 2;
        DoubleDoubleComputer fr2 = new DoubleDoubleComputer(this.p[n], this.p[n + 1]);
        DoubleDoubleComputer dfr2 = new DoubleDoubleComputer();
        DoubleDoubleComputer fi = new DoubleDoubleComputer();
        DoubleDoubleComputer dfi = new DoubleDoubleComputer();
        for (int i = n - 2; i >= 0; i -= 2) {
            double dfrHigh = dfr2.getHigh();
            double dfrLow = dfr2.getLow();
            dfr2 = dfr2.mul(xr).subXY(xi, dfi).add(fr2);
            dfi = dfi.mul(xr).addXY(dfrHigh, dfrLow, xi.getHigh(), xi.getLow()).add(fi);
            double frHigh = fr2.getHigh();
            double frLow = fr2.getLow();
            fr2 = fr2.mul(xr).subXY(xi, fi).add(this.p[i], this.p[i + 1]);
            fi = fi.mul(xr).addXY(frHigh, frLow, xi.getHigh(), xi.getLow());
        }
        this.df = DoubleComplex.cart(dfr2, dfi);
        this.f = DoubleComplex.cart(fr2, fi);
        return this;
    }

    public DoublePolynomialComputer compute(DoubleDouble x) {
        this.df = null;
        int n = this.p.length - 2;
        DoubleDoubleComputer r = new DoubleDoubleComputer(this.p[n], this.p[n + 1]);
        for (int i = n - 2; i >= 0; i -= 2) {
            r.mul(x).add(this.p[i], this.p[i + 1]);
        }
        this.f = DoubleComplex.cart(r, DoubleDouble.ZERO);
        return this;
    }

    public DoublePolynomialComputer computeAll(DoubleDouble x) {
        int n = this.p.length - 2;
        DoubleDoubleComputer fr2 = new DoubleDoubleComputer(this.p[n], this.p[n + 1]);
        DoubleDoubleComputer dfr2 = new DoubleDoubleComputer();
        for (int i = n - 2; i >= 0; i -= 2) {
            dfr2.mul(x).add(fr2);
            fr2.mul(x).add(this.p[i], this.p[i + 1]);
        }
        this.df = DoubleComplex.cart(dfr2, DoubleDouble.ZERO);
        this.f = DoubleComplex.cart(fr2, DoubleDouble.ZERO);
        return this;
    }

    public DoubleComplex f() {
        return this.f;
    }

    public DoubleComplex df() {
        return this.df;
    }

    public DoubleDouble df(int n, DoubleDoubleType x) {
        if (n >= this.p.length - 0) {
            return DoubleDouble.ZERO;
        }
        DoublePolynomial P = this.D(n);
        return P.evaluateAt(x);
    }

    public DoubleComplex df(int n, DoubleComplex x) {
        if (n >= this.p.length - 0) {
            return DoubleComplex.ZERO;
        }
        DoublePolynomial P = this.D(n);
        DoublePolynomialComputer cpt = new DoublePolynomialComputer(P).compute(x);
        return cpt.f;
    }

    public DoublePolynomial D(int n) {
        DoublePolynomial P = DoublePolynomial.ofInternal(this.p);
        int d = 0;
        while (d++ < n) {
            P = P.derivate();
        }
        return P;
    }
}

