/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.highprecision.DoubleComplex;
import jdplus.toolkit.base.core.math.highprecision.DoubleDouble;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleComputer;
import jdplus.toolkit.base.core.math.highprecision.DoubleDoubleType;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class DoublePolynomial {
    public static final DoublePolynomial ZERO = new DoublePolynomial(new double[]{0.0, 0.0});
    public static final DoublePolynomial ONE = new DoublePolynomial(new double[]{1.0, 0.0});
    private final double[] c;

    public static DoublePolynomial of(DoubleSeq q) {
        int len = q.length();
        double[] p = new double[2 * len];
        DoubleSeqCursor cursor = q.cursor();
        for (int i = 0; i < len; ++i) {
            p[i << 1] = cursor.getAndNext();
        }
        return DoublePolynomial.ofInternal(p);
    }

    public static DoublePolynomial of(Complex[] roots, double c) {
        int i;
        if (roots == null || roots.length == 1) {
            return new DoublePolynomial(new double[]{c, 0.0});
        }
        int deg = roots.length;
        double[] pcoeff = new double[2 * (deg + 1)];
        DoubleComplex[] p = new DoubleComplex[deg + 1];
        p[0] = DoubleComplex.cart(c, 0.0);
        for (i = 0; i < roots.length; ++i) {
            p[i + 1] = p[i];
            for (int j = i; j >= 1; --j) {
                p[j] = p[j - 1].minus(p[j].times(roots[i]));
            }
            p[0] = p[0].times(roots[i].negate());
        }
        for (i = 0; i <= deg; ++i) {
            pcoeff[2 * i] = p[i].getRe().getHigh();
            pcoeff[2 * i + 1] = p[i].getRe().getLow();
        }
        DoublePolynomial pol = new DoublePolynomial(pcoeff);
        return pol;
    }

    public static DoublePolynomial of2(Complex[] roots, double c) {
        if (roots == null || roots.length == 1) {
            return new DoublePolynomial(new double[]{c, 0.0});
        }
        int deg = roots.length;
        double[] p = new double[2 * (deg + 1)];
        p[0] = c;
        DoubleDoubleComputer cpt = new DoubleDoubleComputer();
        int j = 0;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            if (Math.abs(root.getIm()) < 1.0E-8) {
                double a = -root.getRe();
                p[j + 2] = p[j];
                p[j + 3] = p[j + 1];
                for (int k = j; k >= 2; k -= 2) {
                    cpt.set(p[k - 2], p[k - 1]).addXY(a, 0.0, p[k], p[k + 1]);
                    p[k] = cpt.getHigh();
                    p[k + 1] = cpt.getLow();
                }
                cpt.set(p[0], p[1]).mul(a, 0.0);
                p[0] = cpt.getHigh();
                p[1] = cpt.getLow();
                j += 2;
                continue;
            }
            if (!(root.getIm() >= 1.0E-8)) continue;
            DoubleComplex R = DoubleComplex.of(root);
            DoubleDouble a = R.getRe().times(-2.0);
            DoubleDouble b = R.absSquare();
            p[j + 4] = p[j];
            p[j + 5] = p[j + 1];
            if (j >= 2) {
                cpt.set(p[j], p[j + 1]).mul(a).add(p[j - 2], p[j - 1]);
                p[j + 2] = cpt.getHigh();
                p[j + 3] = cpt.getLow();
            }
            for (int k = j; k >= 4; k -= 2) {
                cpt.set(p[k - 4], p[k - 3]).addXY(a.getHigh(), a.getLow(), p[k - 2], p[k - 1]).addXY(b.getHigh(), b.getLow(), p[k], p[k + 1]);
                p[k] = cpt.getHigh();
                p[k + 1] = cpt.getLow();
            }
            cpt.set(p[2], p[3]).mul(b).addXY(a.getHigh(), a.getLow(), p[0], p[1]);
            p[2] = cpt.getHigh();
            p[3] = cpt.getLow();
            cpt.set(p[0], p[1]).mul(b);
            p[0] = cpt.getHigh();
            p[1] = cpt.getLow();
            j += 4;
        }
        DoublePolynomial pol = new DoublePolynomial(p);
        return pol;
    }

    static DoublePolynomial of(double[] p) {
        int n;
        for (n = p.length; n > 1 && p[n - 1] == 0.0 && p[n - 2] == 0.0; n -= 2) {
        }
        double[] np = new double[n];
        System.arraycopy(p, 0, np, 0, n);
        return new DoublePolynomial(np);
    }

    static DoublePolynomial ofInternal(double[] p) {
        return DoublePolynomial.ofInternal(p, p.length);
    }

    static DoublePolynomial ofInternal(double[] p, int n) {
        while (n > 1 && p[n - 1] == 0.0 && p[n - 2] == 0.0) {
            n -= 2;
        }
        if (n == p.length) {
            return new DoublePolynomial(p);
        }
        double[] np = new double[n];
        System.arraycopy(p, 0, np, 0, n);
        return new DoublePolynomial(np);
    }

    private DoublePolynomial(double[] c) {
        this.c = c;
    }

    public int degree() {
        return (this.c.length >> 1) - 1;
    }

    public Polynomial asPolynomial() {
        double[] p = new double[this.c.length >> 1];
        int i = 0;
        int j = 0;
        while (i < p.length) {
            p[i] = this.c[j] + this.c[j + 1];
            ++i;
            j += 2;
        }
        return Polynomial.ofInternal(p);
    }

    public DoublePolynomial derivate() {
        if (this.c.length == 2) {
            return ZERO;
        }
        int n = this.c.length - 2;
        double[] result = new double[n];
        DoubleDoubleComputer cpt = new DoubleDoubleComputer();
        for (int i = 2; i <= n; i += 2) {
            cpt.set(this.c[i], this.c[i + 1]);
            cpt.mul(i >> 1);
            result[i - 2] = cpt.getHigh();
            result[i - 1] = cpt.getLow();
        }
        return new DoublePolynomial(result);
    }

    public DoubleDouble get(int idx) {
        int pos = idx << 1;
        return new DoubleDouble(this.c[pos], this.c[pos + 1]);
    }

    public DoublePolynomial plus(double d) {
        return this.plus(d, 0.0);
    }

    public DoublePolynomial plus(DoubleDouble d) {
        return this.plus(d.getHigh(), d.getLow());
    }

    DoublePolynomial plus(double dhigh, double dlow) {
        if (dhigh == 0.0 && dlow == 0.0) {
            return this;
        }
        double[] nc = new double[this.c.length];
        DoubleDoubleComputer dc = new DoubleDoubleComputer();
        for (int i = 0; i < this.c.length; i += 2) {
            dc.set(this.c[i], this.c[i + 1]);
            dc.add(dhigh, dlow);
            nc[i] = dc.getHigh();
            nc[i + 1] = dc.getLow();
        }
        return DoublePolynomial.ofInternal(nc);
    }

    public DoublePolynomial mul(double d) {
        return this.mul(d, 0.0);
    }

    public DoublePolynomial mul(DoubleDouble d) {
        return this.mul(d.getHigh(), d.getLow());
    }

    DoublePolynomial mul(double dhigh, double dlow) {
        if (dhigh == 1.0 && dlow == 0.0) {
            return this;
        }
        double[] nc = new double[this.c.length];
        DoubleDoubleComputer dc = new DoubleDoubleComputer();
        for (int i = 0; i < this.c.length; i += 2) {
            dc.set(this.c[i], this.c[i + 1]);
            dc.mul(dhigh, dlow);
            nc[i] = dc.getHigh();
            nc[i + 1] = dc.getLow();
        }
        return DoublePolynomial.ofInternal(nc);
    }

    public DoublePolynomial div(DoubleDouble d) {
        return this.mul(d.getHigh(), d.getLow());
    }

    DoublePolynomial div(double dhigh, double dlow) {
        if (dhigh == 1.0 && dlow == 0.0) {
            return this;
        }
        double[] nc = new double[this.c.length];
        DoubleDoubleComputer dc = new DoubleDoubleComputer();
        for (int i = 0; i < this.c.length; i += 2) {
            dc.set(this.c[i], this.c[i + 1]);
            dc.div(dhigh, dlow);
            nc[i] = dc.getHigh();
            nc[i + 1] = dc.getLow();
        }
        return DoublePolynomial.ofInternal(nc);
    }

    DoubleDouble evaluateAt(double xhigh, double xlow) {
        int i = this.c.length - 2;
        DoubleDoubleComputer computer = new DoubleDoubleComputer(this.c[i], this.c[i + 1]);
        i -= 2;
        while (i >= 0) {
            computer.mul(xhigh, xlow).add(this.c[i], this.c[i + 1]);
            i -= 2;
        }
        return computer.result();
    }

    public DoubleDouble evaluateAt(DoubleDoubleType dd) {
        return this.evaluateAt(dd.getHigh(), dd.getLow());
    }

    public DoubleDouble evaluatAt(double d) {
        return this.evaluateAt(d, 0.0);
    }

    double[] storage() {
        return this.c;
    }

    public static Division divide(DoublePolynomial num, DoublePolynomial denom) {
        int n = num.degree();
        int nv = denom.degree();
        if (nv > n) {
            return new Division(num, ZERO);
        }
        double[] r = (double[])num.storage().clone();
        double[] q = new double[2 * (n - nv + 1)];
        double[] d = denom.storage();
        DoubleDoubleComputer cpt = new DoubleDoubleComputer();
        for (int k = n - nv; k >= 0; --k) {
            int ri = nv + k << 1;
            int di = nv << 1;
            int qi = k << 1;
            cpt.set(r[ri], r[ri + 1]);
            cpt.div(d[di], d[di + 1]);
            q[qi] = cpt.getHigh();
            q[qi + 1] = cpt.getLow();
            for (int j = nv + k - 1; j >= k; --j) {
                di = j - k << 1;
                ri = j << 1;
                qi = k << 1;
                cpt.set(q[qi], q[qi + 1]);
                cpt.mul(d[di], d[di + 1]);
                cpt.chs();
                cpt.add(r[ri], r[ri + 1]);
                r[ri] = cpt.getHigh();
                r[ri + 1] = cpt.getLow();
            }
        }
        DoublePolynomial Q = DoublePolynomial.ofInternal(q);
        DoublePolynomial R = nv > 0 ? DoublePolynomial.ofInternal(r, 2 * (nv + 1)) : ZERO;
        return new Division(R, Q);
    }

    public static final class Division {
        private final DoublePolynomial remainder;
        private final DoublePolynomial quotient;

        private Division(DoublePolynomial remainder, DoublePolynomial quotient) {
            this.remainder = remainder;
            this.quotient = quotient;
        }

        public DoublePolynomial getQuotient() {
            return this.quotient;
        }

        public DoublePolynomial getRemainder() {
            return this.remainder;
        }
    }
}

