/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.bfgs;

import java.util.Locale;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.functions.FunctionException;
import jdplus.toolkit.base.core.math.functions.FunctionMinimizer;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;

public class Bfgs
implements FunctionMinimizer {
    private static final double STEPREDN = 0.2;
    private static final double ACCTOL = 1.0E-4;
    private static final double RELTEST = 10.0;
    private final double stepredn;
    private final double acctol;
    private final double reltest;
    private final int maxit;
    private final boolean trace;
    private final int nreport;
    private final double abstol;
    private final double reltol;
    private int fail;
    private int iter;
    private int grcount;
    private int fncount;
    private IFunctionPoint fcur;
    private double Fmin;
    private double[] btry;
    private FastMatrix H;
    private DoubleSeq g;

    public static BfgsBuilder builder() {
        return new BfgsBuilder();
    }

    public int getFailCode() {
        return this.fail;
    }

    public int getGradientCount() {
        return this.grcount;
    }

    public int getFnCount() {
        return this.fncount;
    }

    public Bfgs(BfgsBuilder builder) {
        this.abstol = builder.abstol;
        this.acctol = builder.acctol;
        this.maxit = builder.maxit;
        this.nreport = builder.nreport;
        this.reltest = builder.reltest;
        this.reltol = builder.reltol;
        this.stepredn = builder.stepredn;
        this.trace = builder.trace;
    }

    private void vmmin(DoubleSeq b, IFunction fn) {
        int count;
        this.iter = 0;
        this.btry = b.toArray();
        int n = this.btry.length;
        this.fcur = fn.evaluate(b);
        double f = this.fcur.getValue();
        if (this.maxit <= 0 || n == 0) {
            this.fail = 0;
            this.Fmin = this.fcur.getValue();
            this.grcount = 0;
            this.fncount = 0;
            return;
        }
        if (this.nreport <= 0) {
            throw new FunctionException("REPORT must be > 0 (method = \"BFGS\")");
        }
        double[] t = new double[n];
        FastMatrix B = FastMatrix.square(n);
        if (!Double.isFinite(f)) {
            throw new FunctionException("initial value in 'vmmin' is not finite");
        }
        if (this.trace) {
            System.out.println("initial  value " + f);
        }
        this.Fmin = f;
        int gradcount = 1;
        int funcount = 1;
        this.g = this.fcur.derivatives().gradient();
        ++this.iter;
        int ilast = gradcount;
        do {
            double s;
            int i;
            if (ilast == gradcount) {
                B.set(0.0);
                B.diagonal().set(1.0);
            }
            double[] X = (double[])this.btry.clone();
            double[] c = this.g.toArray();
            double gradproj = 0.0;
            DataBlockIterator bcols = B.columnsIterator();
            DoubleSeqCursor gcur = this.g.cursor();
            for (i = 0; i < n; ++i) {
                t[i] = s = -bcols.next().dot(this.g);
                gradproj += s * gcur.getAndNext();
            }
            if (gradproj < 0.0) {
                boolean enough;
                double steplength = 1.0;
                boolean accpoint = false;
                do {
                    count = 0;
                    for (i = 0; i < n; ++i) {
                        this.btry[i] = X[i] + steplength * t[i];
                        if (this.reltest + X[i] != this.reltest + this.btry[i]) continue;
                        ++count;
                    }
                    if (count >= n) continue;
                    DoubleSeq Btry = DoubleSeq.of((double[])this.btry);
                    if (fn.getDomain().checkBoundaries(Btry)) {
                        this.fcur = fn.evaluate(Btry);
                        f = this.fcur.getValue();
                        ++funcount;
                        accpoint = Double.isFinite(f) && f <= this.Fmin + gradproj * steplength * this.acctol;
                    } else {
                        accpoint = false;
                    }
                    if (accpoint) continue;
                    steplength *= this.stepredn;
                } while (count != n && !accpoint);
                boolean bl = enough = f > this.abstol && Math.abs(f - this.Fmin) > this.reltol * (Math.abs(this.Fmin) + this.reltol);
                if (!enough) {
                    count = n;
                    this.Fmin = f;
                }
                if (count < n) {
                    this.Fmin = f;
                    this.g = this.fcur.derivatives().gradient();
                    ++gradcount;
                    ++this.iter;
                    double D1 = 0.0;
                    for (i = 0; i < n; ++i) {
                        t[i] = steplength * t[i];
                        c[i] = this.g.get(i) - c[i];
                        D1 += t[i] * c[i];
                    }
                    if (D1 > 0.0) {
                        double D2 = 0.0;
                        bcols.begin();
                        DataBlock C = DataBlock.of(c);
                        for (i = 0; i < n; ++i) {
                            X[i] = s = bcols.next().dot(C);
                            D2 += s * c[i];
                        }
                        D2 = 1.0 + D2 / D1;
                        for (i = 0; i < n; ++i) {
                            for (int j = 0; j <= i; ++j) {
                                B.add(i, j, (D2 * t[i] * t[j] - X[i] * t[j] - t[i] * X[j]) / D1);
                            }
                        }
                        SymmetricMatrix.fromLower(B);
                    } else {
                        ilast = gradcount;
                    }
                } else if (ilast < gradcount) {
                    count = 0;
                    ilast = gradcount;
                }
            } else {
                count = 0;
                if (ilast == gradcount) {
                    count = n;
                } else {
                    ilast = gradcount;
                }
            }
            if (this.trace && this.iter % this.nreport == 0) {
                System.out.printf(Locale.ROOT, "iter%4d value %f", this.iter, f).println();
            }
            if (this.iter >= this.maxit) break;
            if (gradcount - ilast <= 2 * n) continue;
            ilast = gradcount;
        } while (count != n || ilast != gradcount);
        if (this.trace) {
            System.out.printf(Locale.ROOT, "final  value %f", this.Fmin).println();
            if (this.iter < this.maxit) {
                System.out.println("converged");
            } else {
                System.out.printf(Locale.ROOT, "stopped after %d iterations\n", this.iter).println();
            }
        }
        this.fail = this.iter < this.maxit ? 0 : 1;
        this.fncount = funcount;
        this.grcount = gradcount;
        try {
            this.H = SymmetricMatrix.inverse(B);
        }
        catch (MatrixException err) {
            this.H = this.fcur.derivatives().hessian();
        }
    }

    public BfgsBuilder toBuilder() {
        BfgsBuilder builder = new BfgsBuilder();
        builder.abstol = this.abstol;
        builder.acctol = this.acctol;
        builder.maxit = this.maxit;
        builder.nreport = this.nreport;
        builder.reltest = this.reltest;
        builder.reltol = this.reltol;
        builder.stepredn = this.stepredn;
        builder.trace = this.trace;
        return builder;
    }

    @Override
    public int getIterationsCount() {
        return this.iter;
    }

    @Override
    public FastMatrix curvatureAtMinimum() {
        return this.H;
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        return this.g;
    }

    @Override
    public IFunctionPoint getResult() {
        return this.fcur;
    }

    @Override
    public double getObjective() {
        return this.Fmin;
    }

    @Override
    public boolean minimize(IFunctionPoint start) {
        this.vmmin(start.getParameters(), start.getFunction());
        return this.fail == 0;
    }

    public static class BfgsBuilder
    implements FunctionMinimizer.Builder {
        private double stepredn = 0.2;
        private double acctol = 1.0E-4;
        private double reltest = 10.0;
        private int maxit = 1000;
        private boolean trace = false;
        private int nreport = 10;
        private double abstol = 1.0E-9;
        private double reltol = 1.0E-9;

        @Override
        public BfgsBuilder maxIter(int maxiter) {
            this.maxit = maxiter;
            return this;
        }

        public BfgsBuilder trace(boolean trace) {
            this.trace = trace;
            return this;
        }

        public BfgsBuilder reportingInterval(int nreport) {
            this.nreport = nreport;
            return this;
        }

        public BfgsBuilder stepReduction(double stepredn) {
            this.stepredn = stepredn;
            return this;
        }

        public BfgsBuilder absolutePrecision(double abstol) {
            this.abstol = abstol;
            return this;
        }

        @Override
        public BfgsBuilder functionPrecision(double reltol) {
            this.reltol = reltol;
            return this;
        }

        @Override
        public Bfgs build() {
            return new Bfgs(this);
        }
    }
}

