/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import internal.toolkit.base.core.dstats.Utility;
import java.util.Formatter;
import java.util.Locale;
import jdplus.toolkit.base.api.data.Interval;
import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.SpecialFunctions;
import lombok.NonNull;

public final class Normal
implements ContinuousDistribution {
    private final double mean;
    private final double stdev;

    public Normal() {
        this.mean = 0.0;
        this.stdev = 1.0;
    }

    public Normal(double mean, double stdev) {
        this.mean = mean;
        this.stdev = stdev;
    }

    double evaluate(double x) {
        return this.getProbability(x, ProbabilityType.Lower);
    }

    public Interval getConfidenceInterval(double p) {
        double r0;
        double r1 = this.getProbabilityInverse((1.0 - p) / 2.0, ProbabilityType.Upper);
        if (r1 < (r0 = 2.0 * this.mean - r1)) {
            double tmp = r0;
            r0 = r1;
            r1 = tmp;
        }
        Interval ni = new Interval(r0 * this.stdev + this.mean, r1 * this.stdev + this.mean);
        return ni;
    }

    public double getDensity(double x) {
        return SpecialFunctions.normalDensity(x, this.mean, this.stdev);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Normal with Mean = ");
        sb.append(this.mean);
        sb.append(" and Stdev = ");
        sb.append(this.stdev);
        return sb.toString();
    }

    public double getStdev() {
        return this.stdev;
    }

    public double getExpectation() {
        return this.mean;
    }

    public double getVariance() {
        return this.stdev * this.stdev;
    }

    public double getSkewness() {
        return 0.0;
    }

    public double getKurtosis() {
        if (this.stdev == 1.0) {
            return 3.0;
        }
        double var = this.stdev * this.stdev;
        return 3.0 * var * var;
    }

    public double getLeftBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getMean() {
        return this.mean;
    }

    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        double zx = (x - this.mean) / this.stdev;
        return Utility.intProbability(zx, pt);
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return Double.NaN;
        }
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)", "Normal");
        }
        double zp = Utility.intProbabilityInverse(p, x -> Utility.intProbability(x, ProbabilityType.Lower));
        return zp * this.stdev + this.mean;
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public Interval getSignificanceInterval(double x) {
        double r0;
        double r1 = this.getProbabilityInverse(x / 2.0, ProbabilityType.Upper);
        if (r1 < (r0 = 2.0 * this.mean - r1)) {
            double tmp = r0;
            r0 = r1;
            r1 = tmp;
        }
        Interval ni = new Interval(r0 * this.stdev + this.mean, r1 * this.stdev + this.mean);
        return ni;
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.None;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return true;
    }

    public double random(@NonNull RandomNumberGenerator rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return Normal.random(rng, this.mean, this.stdev);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("N(");
        sb.append(new Formatter(Locale.ROOT).format("%g4", this.mean));
        sb.append(',');
        sb.append(new Formatter(Locale.ROOT).format("%g4", this.stdev));
        sb.append(')');
        return sb.toString();
    }

    public static double random(@NonNull RandomNumberGenerator rng, double mean, double stdev) {
        double x2;
        double x1;
        double w;
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        while ((w = (x1 = 2.0 * rng.nextDouble() - 1.0) * x1 + (x2 = 2.0 * rng.nextDouble() - 1.0) * x2) >= 1.0 || w < 1.0E-30) {
        }
        w = Math.sqrt(-2.0 * Math.log(w) / w);
        return (x1 *= w) * stdev + mean;
    }
}

