/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import lombok.NonNull;

public final class MultivariateNormal {
    private static final Normal N = new Normal(0.0, 1.0);
    private final DataBlock mean;
    private final FastMatrix cov;
    private volatile FastMatrix lchol;

    public MultivariateNormal(DoubleSeq mean, FastMatrix cov) {
        this.mean = DataBlock.of(mean);
        this.cov = cov.deepClone();
    }

    public DataBlock getMean() {
        return this.mean;
    }

    public FastMatrix getCovariance() {
        return this.cov;
    }

    public int getDimension() {
        return this.mean.length();
    }

    public void random(@NonNull RandomNumberGenerator rng, DataBlock rnd) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        rnd.set(() -> N.random(rng));
        FastMatrix lm = this.l();
        LowerTriangularMatrix.xL(lm, rnd);
        rnd.add(this.mean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FastMatrix l() {
        FastMatrix tmp = this.lchol;
        if (tmp == null) {
            MultivariateNormal multivariateNormal = this;
            synchronized (multivariateNormal) {
                tmp = this.lchol;
                if (tmp == null) {
                    tmp = this.cov.deepClone();
                    SymmetricMatrix.lcholesky(tmp, Constants.getEpsilon());
                    this.lchol = tmp;
                }
            }
        }
        return this.lchol;
    }
}

