/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.normalizer;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.normalizer.DataNormalizer;

public class SafeNormalizer
implements DataNormalizer {
    @Override
    public double normalize(DataBlock data) {
        double s = 0.0;
        int n = data.length();
        int m = 0;
        for (int i = 0; i < n; ++i) {
            double d = data.get(i);
            if (!Double.isFinite(d)) continue;
            s += Math.abs(d);
            ++m;
        }
        if (s == 0.0) {
            return 1.0;
        }
        double am = s / (double)m;
        if (am >= 1.0 && am <= 2.0) {
            return 1.0;
        }
        double c = 1.0;
        if (am > 2.0) {
            do {
                c /= 2.0;
            } while ((am /= 2.0) > 2.0);
        } else {
            do {
                c *= 2.0;
            } while ((am *= 2.0) < 1.0);
        }
        data.mul(c);
        return c;
    }
}

