/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.normalizer;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.normalizer.DataNormalizer;

public class AbsMeanNormalizer
implements DataNormalizer {
    @Override
    public double normalize(DataBlock data) {
        double s = 0.0;
        int n = data.length();
        int m = 0;
        for (int i = 0; i < n; ++i) {
            double d = data.get(i);
            if (!Double.isFinite(d)) continue;
            s += Math.abs(d);
            ++m;
        }
        if (s == 0.0) {
            return 1.0;
        }
        double c = (double)m / s;
        data.apply(x -> x * c);
        return c;
    }
}

