/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.interpolation;

import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.data.interpolation.DataInterpolator;
import lombok.Generated;

public final class AverageInterpolator {
    public static DataInterpolator interpolator() {
        return (data, missingpos) -> {
            double[] ndata = data.toArray();
            if (AverageInterpolator.cleanMissings(ndata, missingpos)) {
                return ndata;
            }
            return null;
        };
    }

    public static boolean cleanMissings(double[] y, IntList missings) {
        int ny = y.length;
        int i0 = -1;
        int i1 = -1;
        for (int i = ny - 1; i >= 0; --i) {
            double cur = y[i];
            if (!Double.isFinite(cur)) {
                if (i1 == -1) {
                    i1 = i + 1;
                }
                i0 = i - 1;
                if (missings == null) continue;
                missings.add(i);
                continue;
            }
            if (i0 == -1) continue;
            double v = i1 >= ny ? y[i0] : (y[i1] + y[i0]) / 2.0;
            for (int j = i0 + 1; j < i1; ++j) {
                y[j] = v;
            }
            i1 = -1;
            i0 = -1;
        }
        if (i1 > 0) {
            if (i1 >= ny) {
                return false;
            }
            for (int j = 0; j < i1; ++j) {
                y[j] = y[i1];
            }
        }
        return true;
    }

    @Generated
    private AverageInterpolator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

