/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.accumulator;

import jdplus.toolkit.base.core.data.accumulator.DoubleAccumulator;

public final class NeumaierAccumulator
implements DoubleAccumulator {
    private double del;
    private double sum;

    @Override
    public void reset() {
        this.del = 0.0;
        this.sum = 0.0;
    }

    @Override
    public void add(double x) {
        double t = this.sum + x;
        this.del = Math.abs(this.sum) >= Math.abs(x) ? (this.del += this.sum - t + x) : (this.del += x - t + this.sum);
        this.sum = t;
    }

    @Override
    public double sum() {
        return this.sum + this.del;
    }

    @Override
    public void set(double value) {
        this.del = 0.0;
        this.sum = value;
    }
}

