/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.bayes;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class BayesRegularizedRegressionModel {
    @NonNull
    private final DoubleSeq y;
    @NonNull
    private final Matrix X;
    @NonNull
    private final ModelType model;
    private final int tdof;
    @NonNull
    private final Prior prior;
    @NonNull
    private final Tau2Prior tau2Prior;
    private final int[] categoricalVariables;

    @Generated
    BayesRegularizedRegressionModel(@NonNull DoubleSeq y, @NonNull Matrix X, @NonNull ModelType model, int tdof, @NonNull Prior prior, @NonNull Tau2Prior tau2Prior, int[] categoricalVariables) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (X == null) {
            throw new NullPointerException("X is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (prior == null) {
            throw new NullPointerException("prior is marked non-null but is null");
        }
        if (tau2Prior == null) {
            throw new NullPointerException("tau2Prior is marked non-null but is null");
        }
        this.y = y;
        this.X = X;
        this.model = model;
        this.tdof = tdof;
        this.prior = prior;
        this.tau2Prior = tau2Prior;
        this.categoricalVariables = categoricalVariables;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public DoubleSeq getY() {
        return this.y;
    }

    @NonNull
    @Generated
    public Matrix getX() {
        return this.X;
    }

    @NonNull
    @Generated
    public ModelType getModel() {
        return this.model;
    }

    @Generated
    public int getTdof() {
        return this.tdof;
    }

    @NonNull
    @Generated
    public Prior getPrior() {
        return this.prior;
    }

    @NonNull
    @Generated
    public Tau2Prior getTau2Prior() {
        return this.tau2Prior;
    }

    @Generated
    public int[] getCategoricalVariables() {
        return this.categoricalVariables;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BayesRegularizedRegressionModel)) {
            return false;
        }
        BayesRegularizedRegressionModel other = (BayesRegularizedRegressionModel)o;
        if (this.getTdof() != other.getTdof()) {
            return false;
        }
        DoubleSeq this$y = this.getY();
        DoubleSeq other$y = other.getY();
        if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
            return false;
        }
        Matrix this$X = this.getX();
        Matrix other$X = other.getX();
        if (this$X == null ? other$X != null : !this$X.equals(other$X)) {
            return false;
        }
        ModelType this$model = this.getModel();
        ModelType other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)((Object)this$model)).equals((Object)other$model)) {
            return false;
        }
        Prior this$prior = this.getPrior();
        Prior other$prior = other.getPrior();
        if (this$prior == null ? other$prior != null : !((Object)((Object)this$prior)).equals((Object)other$prior)) {
            return false;
        }
        Tau2Prior this$tau2Prior = this.getTau2Prior();
        Tau2Prior other$tau2Prior = other.getTau2Prior();
        if (this$tau2Prior == null ? other$tau2Prior != null : !((Object)((Object)this$tau2Prior)).equals((Object)other$tau2Prior)) {
            return false;
        }
        return Arrays.equals(this.getCategoricalVariables(), other.getCategoricalVariables());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTdof();
        DoubleSeq $y = this.getY();
        result = result * 59 + ($y == null ? 43 : $y.hashCode());
        Matrix $X = this.getX();
        result = result * 59 + ($X == null ? 43 : $X.hashCode());
        ModelType $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)((Object)$model)).hashCode());
        Prior $prior = this.getPrior();
        result = result * 59 + ($prior == null ? 43 : ((Object)((Object)$prior)).hashCode());
        Tau2Prior $tau2Prior = this.getTau2Prior();
        result = result * 59 + ($tau2Prior == null ? 43 : ((Object)((Object)$tau2Prior)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getCategoricalVariables());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "BayesRegularizedRegressionModel(y=" + String.valueOf(this.getY()) + ", X=" + String.valueOf(this.getX()) + ", model=" + String.valueOf((Object)this.getModel()) + ", tdof=" + this.getTdof() + ", prior=" + String.valueOf((Object)this.getPrior()) + ", tau2Prior=" + String.valueOf((Object)this.getTau2Prior()) + ", categoricalVariables=" + Arrays.toString(this.getCategoricalVariables()) + ")";
    }

    public static enum ModelType {
        GAUSSIAN,
        LAPLACE,
        T,
        BINOMIAL,
        POISSON,
        GEOMETRIC;

    }

    public static enum Prior {
        G,
        RIDGE,
        LASSO,
        HORSESHOE,
        HORSESHOEPLUS,
        LOGT;

    }

    public static enum Tau2Prior {
        HC,
        SB,
        UNIFORM;

    }

    @Generated
    public static class Builder {
        @Generated
        private DoubleSeq y;
        @Generated
        private Matrix X;
        @Generated
        private ModelType model;
        @Generated
        private int tdof;
        @Generated
        private Prior prior;
        @Generated
        private Tau2Prior tau2Prior;
        @Generated
        private int[] categoricalVariables;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder y(@NonNull DoubleSeq y) {
            if (y == null) {
                throw new NullPointerException("y is marked non-null but is null");
            }
            this.y = y;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder X(@NonNull Matrix X) {
            if (X == null) {
                throw new NullPointerException("X is marked non-null but is null");
            }
            this.X = X;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder model(@NonNull ModelType model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tdof(int tdof) {
            this.tdof = tdof;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder prior(@NonNull Prior prior) {
            if (prior == null) {
                throw new NullPointerException("prior is marked non-null but is null");
            }
            this.prior = prior;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tau2Prior(@NonNull Tau2Prior tau2Prior) {
            if (tau2Prior == null) {
                throw new NullPointerException("tau2Prior is marked non-null but is null");
            }
            this.tau2Prior = tau2Prior;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder categoricalVariables(int[] categoricalVariables) {
            this.categoricalVariables = categoricalVariables;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull BayesRegularizedRegressionModel build() {
            return new BayesRegularizedRegressionModel(this.y, this.X, this.model, this.tdof, this.prior, this.tau2Prior, this.categoricalVariables);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "BayesRegularizedRegressionModel.Builder(y=" + String.valueOf(this.y) + ", X=" + String.valueOf(this.X) + ", model=" + String.valueOf((Object)this.model) + ", tdof=" + this.tdof + ", prior=" + String.valueOf((Object)this.prior) + ", tau2Prior=" + String.valueOf((Object)this.tau2Prior) + ", categoricalVariables=" + Arrays.toString(this.categoricalVariables) + ")";
        }
    }
}

