/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.core.math.ComplexMath;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFrequencyResponse;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;

class SymmetricFrequencyResponseDecomposer {
    private double m_var;
    private BackFilter m_bf;
    private int m_freq;
    private double m_epsilon = 1.0E-4;
    private final double m_repsilon = 0.1;

    SymmetricFrequencyResponseDecomposer() {
        this.m_freq = 12;
    }

    SymmetricFrequencyResponseDecomposer(int freq) {
        this.m_freq = freq;
    }

    public boolean decompose(SymmetricFilter sf) {
        Complex[] r;
        UnitRoots ur;
        UnitRoots sur;
        IntToDoubleFunction weights = sf.weights();
        this.m_bf = null;
        if (weights.applyAsDouble(0) <= 0.0) {
            return false;
        }
        SymmetricFrequencyResponse sfr = new SymmetricFrequencyResponse(sf);
        double var = sfr.getIntegral();
        if (var <= 0.0) {
            return false;
        }
        UnitRootsSolver urs = new UnitRootsSolver(this.m_freq);
        Polynomial p = Polynomial.ofInternal(sf.weightsToArray());
        if (urs.factorize(p) && (sur = (ur = urs.getUnitRoots()).sqrt()) != null) {
            this.m_bf = new BackFilter(sur.asPolynomial());
            SymmetricFrequencyResponse sfrur = SymmetricFrequencyResponse.createFromFilter(this.m_bf);
            sfr = sfr.divide(sfrur);
        }
        if (this.m_bf == null) {
            this.m_bf = BackFilter.ONE;
        }
        if ((r = sfr.roots()) != null) {
            boolean[] used = new boolean[r.length];
            int nused = 0;
            for (int i = 0; i < r.length; ++i) {
                if (used[i]) continue;
                if (r[i].getIm() == 0.0) {
                    double x = r[i].getRe();
                    double ro = x * x - 1.0;
                    if (Math.abs(ro) < 1.0E-9) {
                        ro = 0.0;
                    }
                    if (ro >= 0.0) {
                        r[i] = x > 0.0 ? Complex.cart((double)(x + Math.sqrt(ro))) : Complex.cart((double)(x - Math.sqrt(ro)));
                        used[i] = true;
                        ++nused;
                        continue;
                    }
                    int jbest = -1;
                    double del = -1.0;
                    for (int j = i + 1; j < r.length; ++j) {
                        if (used[j] || r[j].getIm() != 0.0) continue;
                        double dcur = Math.abs(r[j].getRe() - x);
                        if (!(del < 0.0) && !(dcur < del)) continue;
                        del = dcur;
                        jbest = j;
                    }
                    if (jbest > 0 && del < 0.1) {
                        used[i] = true;
                        used[jbest] = true;
                        double rr = x * r[jbest].getRe();
                        if (rr < 0.0) {
                            rr = 0.0;
                            x = 0.0;
                        } else {
                            x = x > 0.0 ? Math.sqrt(rr) : -Math.sqrt(rr);
                        }
                        ro = rr - 1.0;
                        ro = ro < 0.0 ? Math.sqrt(-ro) : 0.0;
                        r[i] = Complex.cart((double)x, (double)ro);
                        r[jbest] = Complex.cart((double)x, (double)(-ro));
                        nused += 2;
                        continue;
                    }
                    this.m_bf = null;
                    return false;
                }
                Complex ro = ComplexMath.sqrt((ComplexType)r[i].times(r[i]).minus(1.0));
                Complex c0 = r[i].plus(ro);
                Complex c1 = r[i].minus(ro);
                if (c1.absSquare() < c0.absSquare()) {
                    c1 = c0;
                }
                for (int j = i + 1; j < r.length; ++j) {
                    if (used[j] || !(r[i].conj().minus(r[j]).absSquare() < this.m_epsilon)) continue;
                    used[i] = true;
                    used[j] = true;
                    r[i] = c1;
                    r[j] = c1.conj();
                    nused += 2;
                    break;
                }
                if (used[i]) continue;
                this.m_bf = null;
                return false;
            }
            if (nused != r.length) {
                this.m_bf = null;
                return false;
            }
            Polynomial pr = Polynomial.fromComplexRoots(r);
            pr = pr.divide(pr.get(0));
            BackFilter bfr = new BackFilter(pr);
            this.m_bf = this.m_bf.times(bfr);
        }
        double s = 0.0;
        Polynomial coeff = this.m_bf.asPolynomial();
        for (int i = 0; i <= coeff.degree(); ++i) {
            s += coeff.get(i) * coeff.get(i);
        }
        this.m_var = var / s;
        return true;
    }

    public BackFilter getBFilter() {
        return this.m_bf;
    }

    public double getFactor() {
        return this.m_var;
    }

    public double getPrecision() {
        return this.m_epsilon;
    }

    public int getStartingURValue() {
        return this.m_freq;
    }

    public void setPrecision(double value) {
        this.m_epsilon = value;
    }

    public void setStartingURValue(int value) {
        this.m_freq = value;
    }
}

