/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.roots;

import internal.toolkit.base.core.math.functions.gsl.roots.FSolver;
import internal.toolkit.base.core.math.functions.gsl.roots.GslRootException;
import java.util.function.DoubleUnaryOperator;

public class BisectionSolver
extends FSolver {
    private double fLower;
    private double fUpper;

    public BisectionSolver(DoubleUnaryOperator fn, double lower, double upper) {
        this.function = fn;
        this.lower = lower;
        this.upper = upper;
        this.root = 0.5 * (lower + upper);
        this.fLower = fn.applyAsDouble(lower);
        this.fUpper = fn.applyAsDouble(upper);
        if (this.fLower < 0.0 && this.fUpper < 0.0 || this.fLower > 0.0 && this.fUpper > 0.0) {
            throw new GslRootException("Endpoints do not straddle y=0");
        }
    }

    @Override
    public void iterate() {
        double xLeft = this.lower;
        double xRight = this.upper;
        double f_lower = this.fLower;
        double f_upper = this.fUpper;
        if (f_lower == 0.0) {
            this.root = xLeft;
            this.upper = xLeft;
            return;
        }
        if (f_upper == 0.0) {
            this.root = xRight;
            this.lower = xRight;
            return;
        }
        double xBisect = (xLeft + xRight) / 2.0;
        double fBisect = this.function.applyAsDouble(xBisect);
        if (fBisect == 0.0) {
            this.root = xBisect;
            this.lower = xBisect;
            this.upper = xBisect;
            return;
        }
        if (f_lower > 0.0 && fBisect < 0.0 || f_lower < 0.0 && fBisect > 0.0) {
            this.root = 0.5 * (xLeft + xBisect);
            this.upper = xBisect;
            this.fUpper = fBisect;
        } else {
            this.root = 0.5 * (xBisect + xRight);
            this.lower = xBisect;
            this.fLower = fBisect;
        }
    }
}

